/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.db.TransactionMetrics;
import org.neo4j.test.rule.TestDirectory;

public class RotatableCsvOutputIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private File outputPath;
    private GraphDatabaseService database;
    private static final BiPredicate<Long, Long> MONOTONIC = (newValue, currentValue) -> newValue >= currentValue;
    private static final int MAX_ARCHIVES = 20;

    @Before
    public void setup() {
        this.outputPath = this.testDirectory.directory("metrics");
        this.database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(MetricsSettings.csvPath, this.outputPath.getAbsolutePath()).setConfig(MetricsSettings.csvRotationThreshold, "21").setConfig(MetricsSettings.csvMaxArchives, String.valueOf(20)).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    @After
    public void tearDown() {
        this.database.shutdown();
    }

    @Test
    public void rotateMetricsFile() throws InterruptedException, IOException {
        this.doTransaction();
        RotatableCsvOutputIT.waitForRotation(this.outputPath, TransactionMetrics.TX_COMMITTED);
        File metricsFile = RotatableCsvOutputIT.metricsCsv(this.outputPath, TransactionMetrics.TX_COMMITTED);
        long committedTransactions = MetricsTestHelper.readLongValueAndAssert(metricsFile, MONOTONIC);
        Assert.assertEquals((long)1L, (long)committedTransactions);
        this.doTransaction();
        RotatableCsvOutputIT.waitForRotation(this.outputPath, TransactionMetrics.TX_COMMITTED);
        File metricsFile2 = RotatableCsvOutputIT.metricsCsv(this.outputPath, TransactionMetrics.TX_COMMITTED);
        long committedTransactions2 = MetricsTestHelper.readLongValueAndAssert(metricsFile2, MONOTONIC);
        Assert.assertEquals((long)2L, (long)committedTransactions2);
    }

    private void doTransaction() {
        try (Transaction transaction = this.database.beginTx();){
            this.database.createNode();
            transaction.success();
        }
    }

    private static void waitForRotation(File dbDir, String metric) throws InterruptedException {
        int i = 0;
        while (RotatableCsvOutputIT.getMetricFile(dbDir, metric, i).exists()) {
            ++i;
        }
        if (i >= 20) {
            Assert.fail((String)"Test did not finish before 20 rotations, which means we have rotated away from the file we want to assert on.");
        }
        RotatableCsvOutputIT.metricsCsv(dbDir, metric, i);
    }

    private static File metricsCsv(File dbDir, String metric) throws InterruptedException {
        return RotatableCsvOutputIT.metricsCsv(dbDir, metric, 0L);
    }

    private static File metricsCsv(File dbDir, String metric, long index) throws InterruptedException {
        File csvFile = RotatableCsvOutputIT.getMetricFile(dbDir, metric, index);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics file should exist", csvFile::exists, (Matcher)CoreMatchers.is((Object)true), (long)40L, (TimeUnit)TimeUnit.SECONDS);
        return csvFile;
    }

    private static File getMetricFile(File dbDir, String metric, long index) {
        return new File(dbDir, index > 0L ? metric + ".csv." + index : metric + ".csv");
    }
}

