/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.function.LongConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.logging.Log;
import org.neo4j.metrics.output.PrometheusOutput;
import org.neo4j.ports.allocation.PortAuthority;

public class PrometheusOutputTest {
    @Test
    public void eventsShouldBeRedirectedToGauges() throws Throwable {
        String serverAddress = "localhost:" + PortAuthority.allocatePort();
        MetricRegistry registry = new MetricRegistry();
        PrometheusOutput prometheusOutput = new PrometheusOutput(new HostnamePort(serverAddress), registry, (Log)Mockito.mock(Log.class));
        LongConsumer callback = l -> {
            TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
            gauges.put("my.event", () -> l);
            prometheusOutput.report(gauges, Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap());
        };
        callback.accept(10L);
        prometheusOutput.init();
        prometheusOutput.start();
        Assert.assertTrue((boolean)this.getResponse(serverAddress).contains("my_event 10.0"));
        Assert.assertTrue((boolean)this.getResponse(serverAddress).contains("my_event 10.0"));
        callback.accept(20L);
        Assert.assertTrue((boolean)this.getResponse(serverAddress).contains("my_event 20.0"));
        Assert.assertTrue((boolean)this.getResponse(serverAddress).contains("my_event 20.0"));
    }

    @Test
    public void metricsRegisteredAfterStartShouldBeIncluded() throws Throwable {
        String serverAddress = "localhost:" + PortAuthority.allocatePort();
        MetricRegistry registry = new MetricRegistry();
        PrometheusOutput prometheusOutput = new PrometheusOutput(new HostnamePort(serverAddress), registry, (Log)Mockito.mock(Log.class));
        LongConsumer callback = l -> {
            TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
            gauges.put("my.event", () -> l);
            prometheusOutput.report(gauges, Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap());
        };
        registry.register("my.metric", (Metric)((Gauge)() -> 10));
        prometheusOutput.init();
        prometheusOutput.start();
        callback.accept(20L);
        String response = this.getResponse(serverAddress);
        Assert.assertTrue((boolean)response.contains("my_metric 10.0"));
        Assert.assertTrue((boolean)response.contains("my_event 20.0"));
    }

    private String getResponse(String serverAddress) throws IOException {
        String url = "http://" + serverAddress + "/metrics";
        URLConnection connection = new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.connect();
        Scanner s = new Scanner(connection.getInputStream(), "UTF-8").useDelimiter("\\A");
        Assert.assertTrue((boolean)s.hasNext());
        String ret = s.next();
        Assert.assertFalse((boolean)s.hasNext());
        s.close();
        return ret;
    }
}

