/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.source.db.EntityCountMetrics;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.rule.TestDirectory;

public class PrometheusOutputIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseService database;
    private String serverAddress;

    @Before
    public void setUp() {
        this.serverAddress = "localhost:" + PortAuthority.allocatePort();
        this.database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(MetricsSettings.prometheusEnabled, "true").setConfig(MetricsSettings.prometheusEndpoint, this.serverAddress).newGraphDatabase();
    }

    @After
    public void tearDown() {
        this.database.shutdown();
    }

    @Test
    public void httpEndpointShouldBeAvailableAndResponsive() throws IOException {
        String url = "http://" + this.serverAddress + "/metrics";
        URLConnection connection = new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.connect();
        Scanner s = new Scanner(connection.getInputStream(), "UTF-8").useDelimiter("\\A");
        Assert.assertTrue((boolean)s.hasNext());
        String response = s.next();
        Assert.assertTrue((boolean)response.contains(EntityCountMetrics.COUNTS_NODE));
        Assert.assertTrue((boolean)response.contains(EntityCountMetrics.COUNTS_RELATIONSHIP_TYPE));
    }
}

