/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.output.CsvOutput;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class CsvOutputTest {
    private final LifeRule life = new LifeRule();
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final JobScheduler jobScheduler = new OnDemandJobScheduler();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.life);
    private KernelContext kernelContext;

    @Before
    public void setup() {
        File storeDir = this.directory.directory();
        this.kernelContext = new SimpleKernelContext(storeDir, DatabaseInfo.UNKNOWN, (DependencySatisfier)new Dependencies());
    }

    @Test
    public void shouldHaveRelativeMetricsCsvPathBeRelativeToNeo4jHome() throws Exception {
        File home = this.directory.absolutePath();
        Config config = this.config(MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "10ms", MetricsSettings.csvPath.name(), "the-metrics-dir", GraphDatabaseSettings.neo4j_home.name(), home.getAbsolutePath());
        this.life.add((Lifecycle)this.createCsvOutput(config));
        this.life.start();
        this.waitForFileToAppear(new File(home, "the-metrics-dir"));
    }

    @Test
    public void shouldHaveAbsoluteMetricsCsvPathBeAbsolute() throws Exception {
        File outputFPath = Files.createTempDirectory("output", new FileAttribute[0]).toFile();
        Config config = this.config(MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "10ms", MetricsSettings.csvPath.name(), outputFPath.getAbsolutePath());
        this.life.add((Lifecycle)this.createCsvOutput(config));
        this.life.start();
        this.waitForFileToAppear(outputFPath);
    }

    private CsvOutput createCsvOutput(Config config) {
        return new CsvOutput(config, new MetricRegistry(), (Log)NullLog.getInstance(), this.kernelContext, (FileSystemAbstraction)this.fileSystemRule, this.jobScheduler);
    }

    private Config config(String ... keysValues) {
        return Config.defaults((Map)MapUtil.stringMap((String[])keysValues));
    }

    private void waitForFileToAppear(File file) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (!file.exists()) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() <= end) continue;
            Assert.fail((String)(file + " didn't appear"));
        }
    }
}

