/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.causalclustering.CoreMetrics;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

public class RaftMessageProcessingMetricIT {
    private static final int TIMEOUT = 15;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withSharedCoreParam(CausalClusteringSettings.leader_election_timeout, "1s").withSharedCoreParam(MetricsSettings.metricsEnabled, "true").withSharedCoreParam(MetricsSettings.csvEnabled, "true").withSharedCoreParam(MetricsSettings.csvInterval, "100ms");
    private Cluster cluster;

    @After
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldMonitorMessageDelay() throws Throwable {
        this.cluster = this.clusterRule.startCluster();
        CoreClusterMember leader = this.cluster.awaitLeader();
        File coreMetricsDir = new File(leader.homeDir(), MetricsSettings.csvPath.getDefaultValue());
        Assert.assertEventually((String)"message delay eventually recorded", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.DELAY)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"message timer count eventually recorded", () -> MetricsTestHelper.readTimerLongValueAndAssert(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.TIMER), (newValue, currentValue) -> newValue >= currentValue, MetricsTestHelper.TimerField.COUNT), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"message timer max eventually recorded", () -> MetricsTestHelper.readTimerDoubleValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.TIMER), MetricsTestHelper.TimerField.MAX), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
    }
}

