/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.db.PageCacheMetrics;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class PageCacheMetricsIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private File metricsDirectory;
    private GraphDatabaseService database;

    @Before
    public void setUp() {
        this.metricsDirectory = this.testDirectory.directory("metrics");
        this.database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(MetricsSettings.metricsEnabled, "false").setConfig(MetricsSettings.neoPageCacheEnabled, "true").setConfig(MetricsSettings.csvEnabled, "true").setConfig(MetricsSettings.csvInterval, "100ms").setConfig(MetricsSettings.csvPath, this.metricsDirectory.getAbsolutePath()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    @After
    public void tearDown() {
        this.database.shutdown();
    }

    @Test
    public void pageCacheMetrics() throws Exception {
        Label testLabel = Label.label((String)"testLabel");
        try (Transaction transaction = this.database.beginTx();){
            Node node = this.database.createNode(new Label[]{testLabel});
            node.setProperty("property", (Object)"value");
            transaction.success();
        }
        var3_3 = null;
        try (Transaction ignored = this.database.beginTx();){
            ResourceIterator nodes = this.database.findNodes(testLabel);
            Assert.assertEquals((long)1L, (long)nodes.stream().count());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        this.assertMetrics("Metrics report should include page cache pins", PageCacheMetrics.PC_PINS, (Matcher<Long>)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.assertMetrics("Metrics report should include page cache unpins", PageCacheMetrics.PC_UNPINS, (Matcher<Long>)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.assertMetrics("Metrics report should include page cache evictions", PageCacheMetrics.PC_EVICTIONS, (Matcher<Long>)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        this.assertMetrics("Metrics report should include page cache page faults", PageCacheMetrics.PC_PAGE_FAULTS, (Matcher<Long>)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.assertMetrics("Metrics report should include page cache hits", PageCacheMetrics.PC_HITS, (Matcher<Long>)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.assertMetrics("Metrics report should include page cache flushes", PageCacheMetrics.PC_FLUSHES, (Matcher<Long>)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        this.assertMetrics("Metrics report should include page cache exceptions", PageCacheMetrics.PC_EVICTION_EXCEPTIONS, (Matcher<Long>)Matchers.equalTo((Object)0L));
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics report should include page cache hit ratio", () -> MetricsTestHelper.readDoubleValue(MetricsTestHelper.metricsCsv(this.metricsDirectory, PageCacheMetrics.PC_HIT_RATIO)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(1.0)), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics report should include page cache usage ratio", () -> MetricsTestHelper.readDoubleValue(MetricsTestHelper.metricsCsv(this.metricsDirectory, PageCacheMetrics.PC_USAGE_RATIO)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(1.0)), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    private void assertMetrics(String message, String metricName, Matcher<Long> matcher) throws Exception {
        org.neo4j.test.assertion.Assert.assertEventually((String)message, () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(this.metricsDirectory, metricName)), matcher, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }
}

