/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MetricsTestHelper {
    private MetricsTestHelper() {
    }

    public static long readLongValue(File metricFile) throws IOException, InterruptedException {
        return MetricsTestHelper.readLongValueAndAssert(metricFile, (one, two) -> true);
    }

    public static long readLongValueAndAssert(File metricFile, BiPredicate<Long, Long> assumption) throws IOException, InterruptedException {
        return MetricsTestHelper.readValueAndAssert(metricFile, 0L, GaugeField.TIME_STAMP, GaugeField.METRICS_VALUE, Long::parseLong, assumption);
    }

    static double readDoubleValue(File metricFile) throws IOException, InterruptedException {
        return MetricsTestHelper.readValueAndAssert(metricFile, 0.0, GaugeField.TIME_STAMP, GaugeField.METRICS_VALUE, Double::parseDouble, (one, two) -> true);
    }

    static long readTimerLongValue(File metricFile, TimerField field) throws IOException, InterruptedException {
        return MetricsTestHelper.readTimerLongValueAndAssert(metricFile, (a, b) -> true, field);
    }

    static long readTimerLongValueAndAssert(File metricFile, BiPredicate<Long, Long> assumption, TimerField field) throws IOException, InterruptedException {
        return MetricsTestHelper.readValueAndAssert(metricFile, 0L, TimerField.T, field, Long::parseLong, assumption);
    }

    static double readTimerDoubleValue(File metricFile, TimerField field) throws IOException, InterruptedException {
        return MetricsTestHelper.readTimerDoubleValueAndAssert(metricFile, (a, b) -> true, field);
    }

    static double readTimerDoubleValueAndAssert(File metricFile, BiPredicate<Double, Double> assumption, TimerField field) throws IOException, InterruptedException {
        return MetricsTestHelper.readValueAndAssert(metricFile, 0.0, TimerField.T, field, Double::parseDouble, assumption);
    }

    private static <T, FIELD extends Enum<FIELD>> T readValueAndAssert(File metricFile, T startValue, FIELD timeStampField, FIELD metricsValue, Function<String, T> parser, BiPredicate<T, T> assumption) throws IOException, InterruptedException {
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics file should exist", metricFile::exists, (Matcher)CoreMatchers.is((Object)true), (long)40L, (TimeUnit)TimeUnit.SECONDS);
        try (BufferedReader reader = new BufferedReader(new FileReader(metricFile));){
            String line;
            String s;
            while ((s = reader.readLine()) == null) {
            }
            String[] headers = s.split(",");
            Assert.assertThat((Object)headers.length, (Matcher)CoreMatchers.is((Object)((Enum[])timeStampField.getClass().getEnumConstants()).length));
            Assert.assertThat((Object)headers[timeStampField.ordinal()], (Matcher)CoreMatchers.is((Object)((CsvField)((Object)timeStampField)).header()));
            Assert.assertThat((Object)headers[metricsValue.ordinal()], (Matcher)CoreMatchers.is((Object)((CsvField)((Object)metricsValue)).header()));
            T currentValue = startValue;
            while ((line = reader.readLine()) == null) {
            }
            do {
                String[] fields = line.split(",");
                T newValue = parser.apply(fields[metricsValue.ordinal()]);
                Assert.assertTrue((String)("assertion failed on " + newValue + " " + currentValue), (boolean)assumption.test(newValue, currentValue));
                currentValue = newValue;
            } while ((line = reader.readLine()) != null);
            T t = currentValue;
            return t;
        }
    }

    public static File metricsCsv(File dbDir, String metric) throws InterruptedException {
        File csvFile = new File(dbDir, metric + ".csv");
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics file should exist", csvFile::exists, (Matcher)CoreMatchers.is((Object)true), (long)40L, (TimeUnit)TimeUnit.SECONDS);
        return csvFile;
    }

    static enum TimerField implements CsvField
    {
        T,
        COUNT,
        MAX,
        MEAN,
        MIN,
        STDDEV,
        P50,
        P75,
        P95,
        P98,
        P99,
        P999,
        MEAN_RATE,
        M1_RATE,
        M5_RATE,
        M15_RATE,
        RATE_UNIT,
        DURATION_UNIT;


        @Override
        public String header() {
            return this.name().toLowerCase();
        }
    }

    static enum GaugeField implements CsvField
    {
        TIME_STAMP("t"),
        METRICS_VALUE("value");

        private final String header;

        private GaugeField(String header) {
            this.header = header;
        }

        @Override
        public String header() {
            return this.header;
        }
    }

    static interface CsvField {
        public String header();
    }
}

