/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.cluster.ClusterMetrics;
import org.neo4j.metrics.source.db.CheckPointingMetrics;
import org.neo4j.metrics.source.db.CypherMetrics;
import org.neo4j.metrics.source.db.EntityCountMetrics;
import org.neo4j.metrics.source.db.TransactionMetrics;
import org.neo4j.metrics.source.jvm.ThreadMetrics;
import org.neo4j.test.ha.ClusterRule;

public class MetricsKernelExtensionFactoryIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withSharedSetting(GraphDatabaseSettings.record_id_batch_size, "1");
    private HighlyAvailableGraphDatabase db;
    private File outputPath;

    @Before
    public void setup() {
        this.outputPath = this.clusterRule.directory("metrics");
        Map config = MapUtil.stringMap((String[])new String[]{MetricsSettings.neoEnabled.name(), "true", MetricsSettings.metricsEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", GraphDatabaseSettings.cypher_min_replan_interval.name(), "0m", MetricsSettings.csvPath.name(), this.outputPath.getAbsolutePath(), GraphDatabaseSettings.check_point_interval_time.name(), "100ms", MetricsSettings.graphiteInterval.name(), "1s", OnlineBackupSettings.online_backup_enabled.name(), "false"});
        this.db = this.clusterRule.withSharedConfig(config).withCluster(ClusterManager.clusterOfSize((int)1)).startCluster().getMaster();
        this.addNodes(1);
    }

    @Test
    public void shouldShowTxCommittedMetricsWhenMetricsEnabled() throws Throwable {
        long lastCommittedTransactionId = ((TransactionIdStore)this.db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
        this.addNodes(1000);
        File metricsFile = MetricsTestHelper.metricsCsv(this.outputPath, TransactionMetrics.TX_COMMITTED);
        long committedTransactions = MetricsTestHelper.readLongValueAndAssert(metricsFile, (newValue, currentValue) -> newValue >= currentValue);
        Assert.assertThat((Object)committedTransactions, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(lastCommittedTransactionId)));
        Assert.assertThat((Object)committedTransactions, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(lastCommittedTransactionId + 1001L)));
    }

    @Test
    public void shouldShowEntityCountMetricsWhenMetricsEnabled() throws Throwable {
        this.addNodes(1000);
        File metricsFile = MetricsTestHelper.metricsCsv(this.outputPath, EntityCountMetrics.COUNTS_NODE);
        long committedTransactions = MetricsTestHelper.readLongValueAndAssert(metricsFile, (newValue, currentValue) -> newValue >= currentValue);
        Assert.assertThat((Object)committedTransactions, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1001L)));
    }

    @Test
    public void shouldShowClusterMetricsWhenMetricsEnabled() throws Throwable {
        this.addNodes(1000);
        File metricsFile = MetricsTestHelper.metricsCsv(this.outputPath, ClusterMetrics.IS_MASTER);
        long committedTransactions = MetricsTestHelper.readLongValueAndAssert(metricsFile, (newValue, currentValue) -> newValue >= currentValue);
        Assert.assertThat((Object)committedTransactions, (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void showReplanEvents() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("match (n:Label {name: 'Pontus'}) return n.name").close();
            tx.success();
        }
        this.addNodes(10);
        for (int i = 0; i < 10; ++i) {
            try (Transaction tx = this.db.beginTx();){
                this.db.execute("match (n:Label {name: 'Pontus'}) return n.name").close();
                tx.success();
            }
            this.addNodes(1);
        }
        File replanCountMetricFile = MetricsTestHelper.metricsCsv(this.outputPath, CypherMetrics.REPLAN_EVENTS);
        File replanWaitMetricFile = MetricsTestHelper.metricsCsv(this.outputPath, CypherMetrics.REPLAN_WAIT_TIME);
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        long events = 0L;
        while (System.currentTimeMillis() < endTime && events == 0L) {
            MetricsTestHelper.readLongValueAndAssert(replanWaitMetricFile, (newValue, currentValue) -> newValue >= currentValue);
            events = MetricsTestHelper.readLongValueAndAssert(replanCountMetricFile, (newValue, currentValue) -> newValue >= currentValue);
            if (events != 0L) continue;
            Thread.sleep(300L);
        }
        Assert.assertThat((Object)events, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void shouldUseEventBasedReportingCorrectly() throws Throwable {
        this.addNodes(100);
        CheckPointer checkPointer = (CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class);
        checkPointer.checkPointIfNeeded((TriggerInfo)new SimpleTriggerInfo("test"));
        File metricFile = MetricsTestHelper.metricsCsv(this.outputPath, CheckPointingMetrics.CHECK_POINT_DURATION);
        long result = MetricsTestHelper.readLongValueAndAssert(metricFile, (newValue, currentValue) -> newValue >= 0L);
        Assert.assertThat((Object)result, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void shouldShowMetricsForThreads() throws Throwable {
        this.addNodes(100);
        File threadTotalFile = MetricsTestHelper.metricsCsv(this.outputPath, ThreadMetrics.THREAD_TOTAL);
        File threadCountFile = MetricsTestHelper.metricsCsv(this.outputPath, ThreadMetrics.THREAD_COUNT);
        long threadTotalResult = MetricsTestHelper.readLongValueAndAssert(threadTotalFile, (newValue, currentValue) -> newValue >= 0L);
        long threadCountResult = MetricsTestHelper.readLongValueAndAssert(threadCountFile, (newValue, currentValue) -> newValue >= 0L);
        Assert.assertThat((Object)threadTotalResult, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)threadCountResult, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustBeAbleToStartWithNullTracer() {
        File disabledTracerDb = this.clusterRule.directory("disabledTracerDb");
        GraphDatabaseBuilder builder = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(disabledTracerDb);
        GraphDatabaseService nullTracerDatabase = builder.setConfig(MetricsSettings.neoEnabled, "true").setConfig(MetricsSettings.csvEnabled, "true").setConfig(MetricsSettings.csvPath, this.outputPath.getAbsolutePath()).setConfig(GraphDatabaseFacadeFactory.Configuration.tracer, "null").setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        try (Transaction tx = nullTracerDatabase.beginTx();){
            Node node = nullTracerDatabase.createNode();
            node.setProperty("all", (Object)"is well");
            tx.success();
        }
        finally {
            nullTracerDatabase.shutdown();
        }
    }

    private void addNodes(int numberOfNodes) {
        for (int i = 0; i < numberOfNodes; ++i) {
            try (Transaction tx = this.db.beginTx();){
                Node node = this.db.createNode(new Label[]{Label.label((String)"Label")});
                node.setProperty("name", (Object)UUID.randomUUID().toString());
                tx.success();
                continue;
            }
        }
    }
}

