/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.causalclustering.CatchUpMetrics;
import org.neo4j.metrics.source.causalclustering.CoreMetrics;
import org.neo4j.metrics.source.causalclustering.ReadReplicaMetrics;
import org.neo4j.test.causalclustering.ClusterRule;

public class CoreEdgeMetricsIT {
    private static final int TIMEOUT = 15;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(1).withSharedCoreParam(MetricsSettings.metricsEnabled, "true").withSharedReadReplicaParam(MetricsSettings.metricsEnabled, "true").withSharedCoreParam(MetricsSettings.csvEnabled, "true").withSharedReadReplicaParam(MetricsSettings.csvEnabled, "true").withSharedCoreParam(MetricsSettings.csvInterval, "100ms").withSharedReadReplicaParam(MetricsSettings.csvInterval, "100ms");
    private Cluster cluster;

    @After
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldMonitorCoreEdge() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        CoreClusterMember coreMember = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        for (CoreClusterMember db2 : this.cluster.coreMembers()) {
            this.assertAllNodesVisible((GraphDatabaseAPI)db2.database());
        }
        for (CoreClusterMember db2 : this.cluster.readReplicas()) {
            this.assertAllNodesVisible((GraphDatabaseAPI)db2.database());
        }
        File coreMetricsDir = new File(coreMember.homeDir(), MetricsSettings.csvPath.getDefaultValue());
        org.neo4j.test.assertion.Assert.assertEventually((String)"append index eventually accurate", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.APPEND_INDEX)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"commit index eventually accurate", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.COMMIT_INDEX)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"term eventually accurate", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.TERM)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"leader not found eventually accurate", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.LEADER_NOT_FOUND)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"tx pull requests received eventually accurate", () -> {
            long total = 0L;
            for (File homeDir : this.cluster.coreMembers().stream().map(CoreClusterMember::homeDir).collect(Collectors.toList())) {
                File metricsDir = new File(homeDir, "metrics");
                total += MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsDir, CatchUpMetrics.TX_PULL_REQUESTS_RECEIVED));
            }
            return total;
        }, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"tx retries eventually accurate", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.TX_RETRIES)), (Matcher)CoreMatchers.equalTo((Object)0L), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"is leader eventually accurate", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(coreMetricsDir, CoreMetrics.IS_LEADER)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        File readReplicaMetricsDir = new File(this.cluster.getReadReplicaById(0).homeDir(), "metrics");
        org.neo4j.test.assertion.Assert.assertEventually((String)"pull update request registered", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(readReplicaMetricsDir, ReadReplicaMetrics.PULL_UPDATES)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"pull update request registered", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(readReplicaMetricsDir, ReadReplicaMetrics.PULL_UPDATE_HIGHEST_TX_ID_REQUESTED)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"pull update response received", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(readReplicaMetricsDir, ReadReplicaMetrics.PULL_UPDATE_HIGHEST_TX_ID_RECEIVED)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
    }

    private void assertAllNodesVisible(GraphDatabaseAPI db) throws Exception {
        try (Transaction tx = db.beginTx();){
            ThrowingSupplier nodeCount = () -> Iterables.count((Iterable)db.getAllNodes());
            Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
            org.neo4j.test.assertion.Assert.assertEventually((String)("node to appear on core server " + config.get(CausalClusteringSettings.raft_advertised_address)), (ThrowingSupplier)nodeCount, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
            for (Node node : db.getAllNodes()) {
                Assert.assertEquals((Object)"baz_bat", (Object)node.getProperty("foobar"));
            }
            tx.success();
        }
    }
}

