/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.db.BoltMetrics;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.rule.TestDirectory;

public class BoltMetricsIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseAPI db;
    private TransportConnection conn;
    private final TransportTestUtil util = new TransportTestUtil((Neo4jPack)new Neo4jPackV1());

    @Test
    public void shouldMonitorBolt() throws Throwable {
        int port = PortAuthority.allocatePort();
        File metricsFolder = this.testDirectory.directory("metrics");
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(new BoltConnector((String)"bolt").type, "BOLT").setConfig(new BoltConnector((String)"bolt").enabled, "true").setConfig(new BoltConnector((String)"bolt").listen_address, "localhost:" + port).setConfig(GraphDatabaseSettings.auth_enabled, "false").setConfig(MetricsSettings.metricsEnabled, "false").setConfig(MetricsSettings.boltMessagesEnabled, "true").setConfig(MetricsSettings.csvEnabled, "true").setConfig(MetricsSettings.csvInterval, "100ms").setConfig(MetricsSettings.csvPath, metricsFolder.getAbsolutePath()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        this.conn = new SocketConnection().connect(new HostnamePort("localhost", port)).send(this.util.acceptedVersions(1L, 0L, 0L, 0L)).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient", (Map)MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}))}));
        Assert.assertEventually((String)"session shows up as started", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsFolder, BoltMetrics.SESSIONS_STARTED)), (Matcher)Matchers.equalTo((Object)1L), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"init request shows up as received", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsFolder, BoltMetrics.MESSAGES_RECIEVED)), (Matcher)Matchers.equalTo((Object)1L), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"init request shows up as started", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsFolder, BoltMetrics.MESSAGES_STARTED)), (Matcher)Matchers.equalTo((Object)1L), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"init request shows up as done", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsFolder, BoltMetrics.MESSAGES_DONE)), (Matcher)Matchers.equalTo((Object)1L), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"queue time shows up", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsFolder, BoltMetrics.TOTAL_QUEUE_TIME)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"processing time shows up", () -> MetricsTestHelper.readLongValue(MetricsTestHelper.metricsCsv(metricsFolder, BoltMetrics.TOTAL_PROCESSING_TIME)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    @After
    public void cleanup() throws Exception {
        this.conn.disconnect();
        this.db.shutdown();
    }
}

