/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade.lucene;

import java.io.IOException;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.upgrade.loader.EmbeddedJarLoader;
import org.neo4j.upgrade.lucene.IndexUpgraderWrapper;
import org.neo4j.upgrade.lucene.UpgraderStub;

public class IndexUpgraderWrapperTest {
    @Test
    public void indexUpgraderInvokesLuceneMigrator() throws Throwable {
        IndexUpgraderWrapper upgrader = this.getIndexUpgrader(this.createJarLoader());
        UpgraderStub.resetInvocationMark();
        upgrader.upgradeIndex(Paths.get("some", new String[0]));
        Assert.assertTrue((boolean)UpgraderStub.getInvocationMark());
    }

    @Test
    public void indexUpgraderReleaseResourcesOnClose() throws Throwable {
        EmbeddedJarLoader jarLoader = this.createJarLoader();
        IndexUpgraderWrapper upgrader = this.getIndexUpgrader(jarLoader);
        upgrader.upgradeIndex(Paths.get("some", new String[0]));
        upgrader.close();
        ((EmbeddedJarLoader)Mockito.verify((Object)jarLoader)).close();
    }

    private IndexUpgraderWrapper getIndexUpgrader(EmbeddedJarLoader jarLoader) {
        return new IndexUpgraderWrapper(() -> jarLoader);
    }

    private EmbeddedJarLoader createJarLoader() throws ClassNotFoundException, IOException {
        EmbeddedJarLoader jarLoader = (EmbeddedJarLoader)Mockito.mock(EmbeddedJarLoader.class);
        Mockito.when((Object)jarLoader.loadEmbeddedClass(ArgumentMatchers.anyString())).thenReturn(UpgraderStub.class);
        return jarLoader;
    }
}

