/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.sampler;

import java.util.List;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class AggregatingIndexSampler
implements IndexSampler {
    private List<IndexSampler> indexSamplers;

    public AggregatingIndexSampler(List<IndexSampler> indexSamplers) {
        this.indexSamplers = indexSamplers;
    }

    public IndexSample sampleIndex() {
        return this.indexSamplers.parallelStream().map(this::sampleIndex).reduce(this::combine).get();
    }

    private IndexSample sampleIndex(IndexSampler sampler) {
        try {
            return sampler.sampleIndex();
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexSample combine(IndexSample sample1, IndexSample sample2) {
        long indexSize = Math.addExact(sample1.indexSize(), sample2.indexSize());
        long uniqueValues = Math.addExact(sample1.uniqueValues(), sample2.uniqueValues());
        long sampleSize = Math.addExact(sample1.sampleSize(), sample2.sampleSize());
        return new IndexSample(indexSize, uniqueValues, sampleSize);
    }
}

