/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.api.LuceneIndexValueValidator;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.storable.Values;

class LuceneIndexValueValidatorTest {
    LuceneIndexValueValidatorTest() {
    }

    @Test
    void tooLongArrayIsNotAllowed() {
        int length = Short.MAX_VALUE;
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.getValidator().validate((Object)RandomUtils.nextBytes((int)length)));
        MatcherAssert.assertThat((Object)iae.getMessage(), (Matcher)Matchers.containsString((String)"Property value size is too large for index. Please see index documentation for limitations."));
    }

    @Test
    void stringOverExceedLimitNotAllowed() {
        int length = 65532;
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)length)));
        MatcherAssert.assertThat((Object)iae.getMessage(), (Matcher)Matchers.containsString((String)"Property value size is too large for index. Please see index documentation for limitations."));
    }

    @Test
    void nullIsNotAllowed() {
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.getValidator().validate(null));
        Assertions.assertEquals((Object)iae.getMessage(), (Object)"Null value");
    }

    @Test
    void numberIsValidValue() {
        this.getValidator().validate((Object)5);
        this.getValidator().validate((Object)5.0);
        this.getValidator().validate((Object)Float.valueOf(5.0f));
        this.getValidator().validate((Object)5L);
    }

    @Test
    void shortArrayIsValidValue() {
        this.getValidator().validate((Object)new long[]{1L, 2L, 3L});
        this.getValidator().validate((Object)RandomUtils.nextBytes((int)200));
    }

    @Test
    void shortStringIsValidValue() {
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)5));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)10));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)250));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)450));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)32766));
    }

    private Validator<Object> getValidator() {
        return object -> LuceneIndexValueValidator.INSTANCE.validate(Values.of((Object)object));
    }
}

