/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.ExplicitIndexValueValidator;

class ExplicitIndexValueValidatorTest {
    ExplicitIndexValueValidatorTest() {
    }

    @Test
    void nullIsNotAllowed() {
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ExplicitIndexValueValidator.INSTANCE.validate(null));
        Assertions.assertEquals((Object)iae.getMessage(), (Object)"Null value");
    }

    @Test
    void stringOverExceedLimitNotAllowed() {
        int length = 65532;
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)length)));
        MatcherAssert.assertThat((Object)iae.getMessage(), (Matcher)Matchers.containsString((String)"Property value size is too large for index. Please see index documentation for limitations."));
    }

    @Test
    void nullToStringIsNotAllowed() {
        Object testValue = Mockito.mock(Object.class);
        Mockito.when((Object)testValue.toString()).thenReturn(null);
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ExplicitIndexValueValidator.INSTANCE.validate(testValue));
        MatcherAssert.assertThat((Object)iae.getMessage(), (Matcher)Matchers.containsString((String)"has null toString"));
    }

    @Test
    void numberIsValidValue() {
        ExplicitIndexValueValidator.INSTANCE.validate((Object)5);
        ExplicitIndexValueValidator.INSTANCE.validate((Object)5.0);
        ExplicitIndexValueValidator.INSTANCE.validate((Object)Float.valueOf(5.0f));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)5L);
    }

    @Test
    void shortStringIsValidValue() {
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)5));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)10));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)250));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)450));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)32766));
    }
}

