/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.function.Factory;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckStrategy;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class DuplicateCheckStrategyTest {
    @Parameterized.Parameter
    public Factory<DuplicateCheckStrategy> duplicateCheckStrategyFactory;
    private DuplicateCheckStrategy checkStrategy;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Parameterized.Parameters
    public static List<Factory<? extends DuplicateCheckStrategy>> duplicateCheckStrategies() {
        return Arrays.asList(() -> new DuplicateCheckStrategy.MapDuplicateCheckStrategy(1000), () -> new DuplicateCheckStrategy.BucketsDuplicateCheckStrategy(DuplicateCheckStrategyTest.randomNumberOfEntries()));
    }

    @Before
    public void setUp() {
        this.checkStrategy = (DuplicateCheckStrategy)this.duplicateCheckStrategyFactory.newInstance();
    }

    @Test
    public void checkStringSinglePropertyDuplicates() throws Exception {
        String duplicatedString = "duplicate";
        TextValue propertyValue = Values.stringValue((String)duplicatedString);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node 1 and node 2 share the property value %s", ValueTuple.of((Value[])new Value[]{propertyValue})));
        this.checkStrategy.checkForDuplicate((Value)propertyValue, 1L);
        this.checkStrategy.checkForDuplicate((Value)propertyValue, 2L);
    }

    @Test
    public void checkNumericSinglePropertyDuplicates() throws Exception {
        double duplicatedNumber = 0.33;
        DoubleValue property = Values.doubleValue((double)duplicatedNumber);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node 3 and node 4 share the property value %s", ValueTuple.of((Value[])new Value[]{property})));
        this.checkStrategy.checkForDuplicate((Value)property, 3L);
        this.checkStrategy.checkForDuplicate((Value)property, 4L);
    }

    @Test
    public void duplicateFoundAmongUniqueStringSingleProperty() throws IndexEntryConflictException {
        for (int i = 0; i < DuplicateCheckStrategyTest.randomNumberOfEntries(); ++i) {
            String propertyValue = String.valueOf(i);
            TextValue stringValue = Values.stringValue((String)propertyValue);
            this.checkStrategy.checkForDuplicate((Value)stringValue, (long)i);
        }
        int duplicateTarget = 9998;
        String duplicate = String.valueOf(duplicateTarget);
        TextValue duplicatedValue = Values.stringValue((String)duplicate);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node %d and node 3 share the property value %s", duplicateTarget, ValueTuple.of((Value[])new Value[]{duplicatedValue})));
        this.checkStrategy.checkForDuplicate((Value)duplicatedValue, 3L);
    }

    @Test
    public void duplicateFoundAmongUniqueNumberSingleProperty() throws IndexEntryConflictException {
        double propertyValue = 0.0;
        for (int i = 0; i < DuplicateCheckStrategyTest.randomNumberOfEntries(); ++i) {
            DoubleValue doubleValue = Values.doubleValue((double)propertyValue);
            this.checkStrategy.checkForDuplicate((Value)doubleValue, (long)i);
            propertyValue += 1.0;
        }
        int duplicateTarget = 9992;
        double duplicateValue = duplicateTarget;
        DoubleValue duplicate = Values.doubleValue((double)duplicateValue);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node %d and node 3 share the property value %s", duplicateTarget, ValueTuple.of((Value[])new Value[]{duplicate})));
        this.checkStrategy.checkForDuplicate((Value)duplicate, 3L);
    }

    @Test
    public void noDuplicatesDetectedForUniqueStringSingleProperty() throws IndexEntryConflictException {
        for (int i = 0; i < DuplicateCheckStrategyTest.randomNumberOfEntries(); ++i) {
            String propertyValue = String.valueOf(i);
            TextValue value = Values.stringValue((String)propertyValue);
            this.checkStrategy.checkForDuplicate((Value)value, (long)i);
        }
    }

    @Test
    public void noDuplicatesDetectedForUniqueNumberSingleProperty() throws IndexEntryConflictException {
        double propertyValue = 0.0;
        int numberOfIterations = DuplicateCheckStrategyTest.randomNumberOfEntries();
        for (int i = 0; i < numberOfIterations; ++i) {
            DoubleValue value = Values.doubleValue((double)(propertyValue += 1.0 / (double)numberOfIterations));
            this.checkStrategy.checkForDuplicate((Value)value, (long)i);
        }
    }

    @Test
    public void checkStringMultiplePropertiesDuplicates() throws Exception {
        String duplicateA = "duplicateA";
        String duplicateB = "duplicateB";
        TextValue propertyA = Values.stringValue((String)duplicateA);
        TextValue propertyB = Values.stringValue((String)duplicateB);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node 1 and node 2 share the property value %s", ValueTuple.of((Object[])new Object[]{duplicateA, duplicateB})));
        this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, 1L);
        this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, 2L);
    }

    @Test
    public void checkNumericMultiplePropertiesDuplicates() throws Exception {
        Double duplicatedNumberA = 0.33;
        Integer duplicatedNumberB = 2;
        DoubleValue propertyA = Values.doubleValue((double)duplicatedNumberA);
        IntValue propertyB = Values.intValue((int)duplicatedNumberB);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node 3 and node 4 share the property value %s", ValueTuple.of((Value[])new Value[]{propertyA, propertyB})));
        this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, 3L);
        this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, 4L);
    }

    @Test
    public void duplicateFoundAmongUniqueStringMultipleProperties() throws IndexEntryConflictException {
        TextValue propertyB;
        TextValue propertyA;
        for (int i = 0; i < DuplicateCheckStrategyTest.randomNumberOfEntries(); ++i) {
            String propertyValueA = String.valueOf(i);
            String propertyValueB = String.valueOf(-i);
            propertyA = Values.stringValue((String)propertyValueA);
            propertyB = Values.stringValue((String)propertyValueB);
            this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, (long)i);
        }
        int duplicateTarget = 9998;
        String duplicatedValueA = String.valueOf(duplicateTarget);
        String duplicatedValueB = String.valueOf(-duplicateTarget);
        propertyA = Values.stringValue((String)duplicatedValueA);
        propertyB = Values.stringValue((String)duplicatedValueB);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node %d and node 3 share the property value %s", duplicateTarget, ValueTuple.of((Value[])new Value[]{propertyA, propertyB})));
        this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, 3L);
    }

    @Test
    public void duplicateFoundAmongUniqueNumberMultipleProperties() throws IndexEntryConflictException {
        DoubleValue propertyB;
        DoubleValue propertyA;
        double propertyValue = 0.0;
        for (int i = 0; i < DuplicateCheckStrategyTest.randomNumberOfEntries(); ++i) {
            double propertyValueA = propertyValue;
            double propertyValueB = -propertyValue;
            propertyA = Values.doubleValue((double)propertyValueA);
            propertyB = Values.doubleValue((double)propertyValueB);
            this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, (long)i);
            propertyValue += 1.0;
        }
        int duplicateTarget = 9992;
        double duplicateValueA = duplicateTarget;
        double duplicateValueB = -duplicateTarget;
        propertyA = Values.doubleValue((double)duplicateValueA);
        propertyB = Values.doubleValue((double)duplicateValueB);
        this.expectedException.expect(IndexEntryConflictException.class);
        this.expectedException.expectMessage(String.format("Both node %d and node 3 share the property value %s", duplicateTarget, ValueTuple.of((Object[])new Object[]{duplicateValueA, duplicateValueB})));
        this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, 3L);
    }

    @Test
    public void noDuplicatesDetectedForUniqueStringMultipleProperties() throws IndexEntryConflictException {
        for (int i = 0; i < DuplicateCheckStrategyTest.randomNumberOfEntries(); ++i) {
            String propertyValueA = String.valueOf(i);
            String propertyValueB = String.valueOf(-i);
            TextValue propertyA = Values.stringValue((String)propertyValueA);
            TextValue propertyB = Values.stringValue((String)propertyValueB);
            this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, (long)i);
        }
    }

    @Test
    public void noDuplicatesDetectedForUniqueNumberMultipleProperties() throws IndexEntryConflictException {
        double propertyValueA = 0.0;
        double propertyValueB = 0.0;
        int numberOfIterations = DuplicateCheckStrategyTest.randomNumberOfEntries();
        for (int i = 0; i < numberOfIterations; ++i) {
            DoubleValue propertyA = Values.doubleValue((double)(propertyValueA += 1.0 / (double)numberOfIterations));
            DoubleValue propertyB = Values.doubleValue((double)(propertyValueB -= 1.0 / (double)numberOfIterations));
            this.checkStrategy.checkForDuplicate(new Value[]{propertyA, propertyB}, (long)i);
        }
    }

    private static int randomNumberOfEntries() {
        return ThreadLocalRandom.current().nextInt(10000, 20000);
    }
}

