/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.IndexSearcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

class UniqueDatabaseIndexSamplerTest {
    private final IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final TaskCoordinator taskControl = new TaskCoordinator(0L, TimeUnit.MILLISECONDS);

    UniqueDatabaseIndexSamplerTest() {
    }

    @Test
    void uniqueSamplingUseDocumentsNumber() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.indexSearcher.getIndexReader().numDocs()).thenReturn((Object)17);
        UniqueLuceneIndexSampler sampler = new UniqueLuceneIndexSampler(this.indexSearcher, this.taskControl.newInstance());
        IndexSample sample = sampler.sampleIndex();
        Assertions.assertEquals((long)17L, (long)sample.indexSize());
    }

    @Test
    void uniqueSamplingCancel() {
        Mockito.when((Object)this.indexSearcher.getIndexReader().numDocs()).thenAnswer(invocation -> {
            this.taskControl.cancel();
            return 17;
        });
        UniqueLuceneIndexSampler sampler = new UniqueLuceneIndexSampler(this.indexSearcher, this.taskControl.newInstance());
        IndexNotFoundKernelException notFoundKernelException = (IndexNotFoundKernelException)Assertions.assertThrows(IndexNotFoundKernelException.class, () -> ((UniqueLuceneIndexSampler)sampler).sampleIndex());
        Assertions.assertEquals((Object)notFoundKernelException.getMessage(), (Object)"Index dropped while sampling.");
    }
}

