/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.IndexReaderStub;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartition;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NonUniqueDatabaseIndexSamplerTest {
    private final IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final TaskCoordinator taskControl = new TaskCoordinator(0L, TimeUnit.MILLISECONDS);
    private final IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());

    NonUniqueDatabaseIndexSamplerTest() {
    }

    @Test
    void nonUniqueSamplingCancel() throws IOException {
        Terms terms = NonUniqueDatabaseIndexSamplerTest.getTerms("test", 1);
        Map fieldTermsMap = MapUtil.genericMap((Object[])new Object[]{"0string", terms, "id", terms, "0string", terms});
        IndexReaderStub indexReader = new IndexReaderStub(new SamplingFields(fieldTermsMap));
        Mockito.when((Object)this.indexSearcher.getIndexReader()).thenReturn((Object)indexReader);
        NonUniqueLuceneIndexSampler luceneIndexSampler = this.createSampler();
        this.taskControl.cancel();
        IndexNotFoundKernelException notFoundKernelException = (IndexNotFoundKernelException)Assertions.assertThrows(IndexNotFoundKernelException.class, () -> ((NonUniqueLuceneIndexSampler)luceneIndexSampler).sampleIndex());
        Assertions.assertEquals((Object)notFoundKernelException.getMessage(), (Object)"Index dropped while sampling.");
    }

    @Test
    void nonUniqueIndexSampling() throws Exception {
        Terms aTerms = NonUniqueDatabaseIndexSamplerTest.getTerms("a", 1);
        Terms idTerms = NonUniqueDatabaseIndexSamplerTest.getTerms("id", 2);
        Terms bTerms = NonUniqueDatabaseIndexSamplerTest.getTerms("b", 3);
        Map fieldTermsMap = MapUtil.genericMap((Object[])new Object[]{"0string", aTerms, "id", idTerms, "0array", bTerms});
        IndexReaderStub indexReader = new IndexReaderStub(new SamplingFields(fieldTermsMap));
        indexReader.setElements(new String[4]);
        Mockito.when((Object)this.indexSearcher.getIndexReader()).thenReturn((Object)indexReader);
        Assertions.assertEquals((Object)new IndexSample(4L, 2L, 4L), (Object)this.createSampler().sampleIndex());
    }

    @Test
    void samplingOfLargeNumericValues() throws Exception {
        try (RAMDirectory dir = new RAMDirectory();
             WritableIndexPartition indexPartition = new WritableIndexPartition(new File("testPartition"), (Directory)dir, IndexWriterConfigs.standard());){
            NonUniqueDatabaseIndexSamplerTest.insertDocument(indexPartition, 1L, Long.MAX_VALUE);
            NonUniqueDatabaseIndexSamplerTest.insertDocument(indexPartition, 2L, Integer.MAX_VALUE);
            indexPartition.maybeRefreshBlocking();
            try (PartitionSearcher searcher = indexPartition.acquireSearcher();){
                NonUniqueLuceneIndexSampler sampler = new NonUniqueLuceneIndexSampler(searcher.getIndexSearcher(), this.taskControl.newInstance(), new IndexSamplingConfig(Config.defaults()));
                Assertions.assertEquals((Object)new IndexSample(2L, 2L, 2L), (Object)sampler.sampleIndex());
            }
        }
    }

    private NonUniqueLuceneIndexSampler createSampler() {
        return new NonUniqueLuceneIndexSampler(this.indexSearcher, this.taskControl.newInstance(), this.indexSamplingConfig);
    }

    private static Terms getTerms(String value, int frequency) throws IOException {
        TermsEnum termsEnum = (TermsEnum)Mockito.mock(TermsEnum.class);
        Terms terms = (Terms)Mockito.mock(Terms.class);
        Mockito.when((Object)terms.iterator()).thenReturn((Object)termsEnum);
        Mockito.when((Object)termsEnum.next()).thenReturn((Object)new BytesRef(value.getBytes())).thenReturn(null);
        Mockito.when((Object)termsEnum.docFreq()).thenReturn((Object)frequency);
        return terms;
    }

    private static void insertDocument(WritableIndexPartition partition, long nodeId, Object propertyValue) throws IOException {
        Document doc = LuceneDocumentStructure.documentRepresentingProperties((long)nodeId, (Value[])new Value[]{Values.of((Object)propertyValue)});
        partition.getIndexWriter().addDocument((Iterable)doc);
    }

    private static class SamplingFields
    extends Fields {
        private Map<String, Terms> fieldTermsMap;

        SamplingFields(Map<String, Terms> fieldTermsMap) {
            this.fieldTermsMap = fieldTermsMap;
        }

        public Iterator<String> iterator() {
            return this.fieldTermsMap.keySet().iterator();
        }

        public Terms terms(String field) {
            return this.fieldTermsMap.get(field);
        }

        public int size() {
            return this.fieldTermsMap.size();
        }
    }
}

