/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SimpleIndexReaderTest {
    private final PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
    private final IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
    private final TaskCoordinator taskCoordinator = new TaskCoordinator(0L, TimeUnit.MILLISECONDS);

    SimpleIndexReaderTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.partitionSearcher.getIndexSearcher()).thenReturn((Object)this.indexSearcher);
    }

    @Test
    void releaseSearcherOnClose() throws IOException {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher)).close();
    }

    @Test
    void seekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"test")});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)ArgumentMatchers.any(BooleanQuery.class), (Collector)ArgumentMatchers.any(DocValuesCollector.class));
    }

    @Test
    void scanQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)ArgumentMatchers.any(MatchAllDocsQuery.class), (Collector)ArgumentMatchers.any(DocValuesCollector.class));
    }

    @Test
    void stringRangeSeekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"a", (boolean)false, (String)"b", (boolean)true)});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)ArgumentMatchers.any(TermRangeQuery.class), (Collector)ArgumentMatchers.any(DocValuesCollector.class));
    }

    @Test
    void prefixRangeSeekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"bb")});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)ArgumentMatchers.any(MultiTermQuery.class), (Collector)ArgumentMatchers.any(DocValuesCollector.class));
    }

    @Test
    void numberRangeSeekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)7, (boolean)true, (Number)8, (boolean)true)});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)ArgumentMatchers.any(NumericRangeQuery.class), (Collector)ArgumentMatchers.any(DocValuesCollector.class));
    }

    @Test
    void countIndexedNodesReachSearcher() throws IOException {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.countIndexedNodes(2L, new int[]{3}, new Value[]{Values.of((Object)"testValue")});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)ArgumentMatchers.any(BooleanQuery.class), (Collector)ArgumentMatchers.any(TotalHitCountCollector.class));
    }

    @Test
    void uniqueIndexSamplerForUniqueIndex() {
        SimpleIndexReader uniqueSimpleReader = this.getUniqueSimpleReader();
        MatcherAssert.assertThat((Object)uniqueSimpleReader.createSampler(), (Matcher)Matchers.instanceOf(UniqueLuceneIndexSampler.class));
    }

    @Test
    void nonUniqueIndexSamplerForNonUniqueIndex() {
        SimpleIndexReader uniqueSimpleReader = this.getNonUniqueSimpleReader();
        MatcherAssert.assertThat((Object)uniqueSimpleReader.createSampler(), (Matcher)Matchers.instanceOf(NonUniqueLuceneIndexSampler.class));
    }

    private SimpleIndexReader getNonUniqueSimpleReader() {
        return new SimpleIndexReader(this.partitionSearcher, TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), this.samplingConfig, this.taskCoordinator);
    }

    private SimpleIndexReader getUniqueSimpleReader() {
        return new SimpleIndexReader(this.partitionSearcher, TestIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0}), this.samplingConfig, this.taskCoordinator);
    }
}

