/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=MockitoJUnitRunner.class)
public class PartitionedIndexReaderTest {
    private static final int PROP_KEY = 1;
    private static final int LABEL_ID = 0;
    private IndexDescriptor schemaIndexDescriptor = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
    @Mock
    private IndexSamplingConfig samplingConfig;
    @Mock
    private TaskCoordinator taskCoordinator;
    @Mock
    private PartitionSearcher partitionSearcher1;
    @Mock
    private PartitionSearcher partitionSearcher2;
    @Mock
    private PartitionSearcher partitionSearcher3;
    @Mock
    private SimpleIndexReader indexReader1;
    @Mock
    private SimpleIndexReader indexReader2;
    @Mock
    private SimpleIndexReader indexReader3;

    @Test
    public void partitionedReaderCloseAllSearchers() throws IOException {
        PartitionedIndexReader partitionedIndexReader = this.createPartitionedReader();
        partitionedIndexReader.close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher1)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher2)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher3)).close();
    }

    @Test
    public void seekOverAllPartitions() throws Exception {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        IndexQuery.ExactPredicate query = IndexQuery.exact((int)1, (Object)"Test");
        Mockito.when((Object)this.indexReader1.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L}));
        Mockito.when((Object)this.indexReader2.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{2L}));
        Mockito.when((Object)this.indexReader3.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{3L}));
        MutableLongSet results = PrimitiveLongCollections.asSet((LongIterator)indexReader.query(new IndexQuery[]{query}));
        this.verifyResult((LongSet)results);
    }

    @Test
    public void rangeSeekByNumberOverPartitions() throws Exception {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        IndexQuery.RangePredicate query = IndexQuery.range((int)1, (Number)1, (boolean)true, (Number)2, (boolean)true);
        Mockito.when((Object)this.indexReader1.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L}));
        Mockito.when((Object)this.indexReader2.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{2L}));
        Mockito.when((Object)this.indexReader3.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{3L}));
        MutableLongSet results = PrimitiveLongCollections.asSet((LongIterator)indexReader.query(new IndexQuery[]{query}));
        this.verifyResult((LongSet)results);
    }

    @Test
    public void rangeSeekByStringOverPartitions() throws Exception {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        IndexQuery.RangePredicate query = IndexQuery.range((int)1, (String)"a", (boolean)false, (String)"b", (boolean)true);
        Mockito.when((Object)this.indexReader1.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L}));
        Mockito.when((Object)this.indexReader2.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{2L}));
        Mockito.when((Object)this.indexReader3.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{3L}));
        MutableLongSet results = PrimitiveLongCollections.asSet((LongIterator)indexReader.query(new IndexQuery[]{query}));
        this.verifyResult((LongSet)results);
    }

    @Test
    public void rangeSeekByPrefixOverPartitions() throws Exception {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        IndexQuery.StringPrefixPredicate query = IndexQuery.stringPrefix((int)1, (String)"prefix");
        Mockito.when((Object)this.indexReader1.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L}));
        Mockito.when((Object)this.indexReader2.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{2L}));
        Mockito.when((Object)this.indexReader3.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{3L}));
        MutableLongSet results = PrimitiveLongCollections.asSet((LongIterator)indexReader.query(new IndexQuery[]{query}));
        this.verifyResult((LongSet)results);
    }

    @Test
    public void scanOverPartitions() throws Exception {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        IndexQuery.ExistsPredicate query = IndexQuery.exists((int)1);
        Mockito.when((Object)this.indexReader1.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L}));
        Mockito.when((Object)this.indexReader2.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{2L}));
        Mockito.when((Object)this.indexReader3.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{3L}));
        MutableLongSet results = PrimitiveLongCollections.asSet((LongIterator)indexReader.query(new IndexQuery[]{query}));
        this.verifyResult((LongSet)results);
    }

    @Test
    public void countNodesOverPartitions() {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        Mockito.when((Object)this.indexReader1.countIndexedNodes(1L, new int[]{1}, new Value[]{Values.of((Object)"a")})).thenReturn((Object)1L);
        Mockito.when((Object)this.indexReader2.countIndexedNodes(1L, new int[]{1}, new Value[]{Values.of((Object)"a")})).thenReturn((Object)2L);
        Mockito.when((Object)this.indexReader3.countIndexedNodes(1L, new int[]{1}, new Value[]{Values.of((Object)"a")})).thenReturn((Object)3L);
        Assert.assertEquals((long)6L, (long)indexReader.countIndexedNodes(1L, new int[]{1}, new Value[]{Values.of((Object)"a")}));
    }

    @Test
    public void samplingOverPartitions() throws IndexNotFoundKernelException {
        PartitionedIndexReader indexReader = this.createPartitionedReaderFromReaders();
        Mockito.when((Object)this.indexReader1.createSampler()).thenReturn((Object)new SimpleSampler(1L));
        Mockito.when((Object)this.indexReader2.createSampler()).thenReturn((Object)new SimpleSampler(2L));
        Mockito.when((Object)this.indexReader3.createSampler()).thenReturn((Object)new SimpleSampler(3L));
        IndexSampler sampler = indexReader.createSampler();
        Assert.assertEquals((Object)new IndexSample(6L, 6L, 6L), (Object)sampler.sampleIndex());
    }

    private void verifyResult(LongSet results) {
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(1L));
        Assert.assertTrue((boolean)results.contains(2L));
        Assert.assertTrue((boolean)results.contains(3L));
    }

    private PartitionedIndexReader createPartitionedReaderFromReaders() {
        return new PartitionedIndexReader(this.schemaIndexDescriptor, this.getPartitionReaders());
    }

    private List<SimpleIndexReader> getPartitionReaders() {
        return Arrays.asList(this.indexReader1, this.indexReader2, this.indexReader3);
    }

    private PartitionedIndexReader createPartitionedReader() {
        return new PartitionedIndexReader(this.getPartitionSearchers(), this.schemaIndexDescriptor, this.samplingConfig, this.taskCoordinator);
    }

    private List<PartitionSearcher> getPartitionSearchers() {
        return Arrays.asList(this.partitionSearcher1, this.partitionSearcher2, this.partitionSearcher3);
    }

    private class SimpleSampler
    implements IndexSampler {
        private long sampleValue;

        SimpleSampler(long sampleValue) {
            this.sampleValue = sampleValue;
        }

        public IndexSample sampleIndex() {
            return new IndexSample(this.sampleValue, this.sampleValue, this.sampleValue);
        }
    }
}

