/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.AllNodesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class UniqueDatabaseIndexPopulatorTest {
    private final CleanupRule cleanup = new CleanupRule();
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.cleanup).around((TestRule)this.fileSystemRule);
    private static final int LABEL_ID = 1;
    private static final int PROPERTY_KEY_ID = 2;
    private final DirectoryFactory directoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private static final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    private final NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
    private PartitionedIndexStorage indexStorage;
    private SchemaIndex index;
    private UniqueLuceneIndexPopulator populator;
    private SchemaDescriptor schemaDescriptor;

    @Before
    public void setUp() {
        File folder = this.testDir.directory("folder");
        this.indexStorage = new PartitionedIndexStorage(this.directoryFactory, this.fileSystemRule.get(), folder);
        this.index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor, (Config)Config.defaults()).withIndexStorage(this.indexStorage)).build();
        this.schemaDescriptor = descriptor.schema();
    }

    @After
    public void tearDown() throws Exception {
        if (this.populator != null) {
            this.populator.close(false);
        }
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.index, this.directoryFactory});
    }

    @Test
    public void shouldVerifyThatThereAreNoDuplicates() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, "value3");
        this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(2L), this.getAllNodes(this.getDirectory(), "value2"));
        Assert.assertEquals(Arrays.asList(3L), this.getAllNodes(this.getDirectory(), "value3"));
    }

    private Directory getDirectory() throws IOException {
        File partitionFolder = this.indexStorage.getPartitionFolder(1);
        return this.indexStorage.openDirectory(partitionFolder);
    }

    @Test
    public void shouldUpdateEntryForNodeThatHasAlreadyBeenIndexed() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object)"value1", (Object)"value2"));
        this.populator.close(true);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, this.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(this.getDirectory(), "value2"));
    }

    @Test
    public void shouldUpdateEntryForNodeThatHasPropertyRemovedAndThenAddedAgain() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(this.getDirectory(), "value1"));
    }

    @Test
    public void shouldRemoveEntryForNodeThatHasAlreadyBeenIndexed() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        this.populator.close(true);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, this.getAllNodes(this.getDirectory(), "value1"));
    }

    @Test
    public void shouldBeAbleToHandleSwappingOfIndexValues() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object)"value1", (Object)"value2"));
        updater.process(IndexQueryHelper.change((long)2L, (SchemaDescriptor)this.schemaDescriptor, (Object)"value2", (Object)"value1"));
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(2L), this.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(this.getDirectory(), "value2"));
    }

    @Test
    public void shouldFailAtVerificationStageWithAlreadyIndexedStringValue() throws Exception {
        this.populator = this.newPopulator();
        String value = "value1";
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, value);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, value);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(1L, 2)).thenReturn((Object)Values.of((Object)value));
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(3L, 2)).thenReturn((Object)Values.of((Object)value));
        try {
            this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)Values.of((Object)value), (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)3L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldFailAtVerificationStageWithAlreadyIndexedNumberValue() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, 1);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, 2);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, 1);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(1L, 2)).thenReturn((Object)Values.of((Object)1));
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(3L, 2)).thenReturn((Object)Values.of((Object)1));
        try {
            this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)Values.of((Object)1), (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)3L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldRejectDuplicateEntryWhenUsingPopulatingUpdater() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        Value value = Values.of((Object)"value1");
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(1L, 2)).thenReturn((Object)value);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(3L, 2)).thenReturn((Object)value);
        try {
            IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
            updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
            updater.close();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)value, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)3L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldRejectDuplicateEntryAfterUsingPopulatingUpdater() throws Exception {
        this.populator = this.newPopulator();
        String valueString = "value1";
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{valueString}));
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, valueString);
        Value value = Values.of((Object)valueString);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(1L, 2)).thenReturn((Object)value);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(2L, 2)).thenReturn((Object)value);
        try {
            this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)value, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)2L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldNotRejectDuplicateEntryOnSameNodeIdAfterUsingPopulatingUpdater() throws Exception {
        this.populator = this.newPopulator();
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(1L, 2)).thenReturn((Object)Values.of((Object)"value1"));
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object)"value1", (Object)"value1"));
        updater.close();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, "value3");
        this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(2L), this.getAllNodes(this.getDirectory(), "value2"));
        Assert.assertEquals(Arrays.asList(3L), this.getAllNodes(this.getDirectory(), "value3"));
    }

    @Test
    public void shouldNotRejectIndexCollisionsCausedByPrecisionLossAsDuplicates() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, 1000000000000000001L);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, 2);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, 1000000000000000001L);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(1L, 2)).thenReturn((Object)Values.of((Object)1000000000000000001L));
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(3L, 2)).thenReturn((Object)Values.of((Object)1000000000000000002L));
        this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
    }

    @Test
    public void shouldCheckAllCollisionsFromPopulatorAdd() throws Exception {
        this.populator = this.newPopulator();
        int iterations = 228;
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
        for (int nodeId = 0; nodeId < iterations; ++nodeId) {
            updater.process(IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{1}));
            Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue((long)nodeId, 2)).thenReturn((Object)Values.of((Object)nodeId));
        }
        updater.process(IndexQueryHelper.add((long)iterations, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{1}));
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue((long)iterations, 2)).thenReturn((Object)Values.of((Object)1));
        try {
            updater.close();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)Values.of((Object)1), (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)iterations, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldCheckAllCollisionsFromUpdaterClose() throws Exception {
        this.populator = this.newPopulator();
        int iterations = 228;
        for (int nodeId = 0; nodeId < iterations; ++nodeId) {
            UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, nodeId, 1);
            Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue((long)nodeId, 2)).thenReturn((Object)Values.of((Object)nodeId));
        }
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, iterations, 1);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue((long)iterations, 2)).thenReturn((Object)Values.of((Object)1));
        try {
            this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)Values.of((Object)1), (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)iterations, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldReleaseSearcherProperlyAfterVerifyingDeferredConstraints() throws Exception {
        this.populator = this.newPopulator();
        OtherThreadExecutor executor = (OtherThreadExecutor)this.cleanup.add((AutoCloseable)new OtherThreadExecutor("Deferred", null));
        executor.execute(state -> {
            IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
            Throwable throwable = null;
            if (updater != null) {
                if (throwable != null) {
                    try {
                        updater.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    updater.close();
                }
            }
            return null;
        });
        executor.execute(state -> {
            this.populator.verifyDeferredConstraints(this.nodePropertyAccessor);
            return null;
        });
        executor.execute(state -> {
            IndexUpdater secondUpdater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
            Throwable throwable = null;
            if (secondUpdater != null) {
                if (throwable != null) {
                    try {
                        secondUpdater.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    secondUpdater.close();
                }
            }
            return null;
        }, 5L, TimeUnit.SECONDS);
    }

    @Test
    public void sampleEmptyIndex() throws Exception {
        this.populator = this.newPopulator();
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(), (Object)sample);
    }

    @Test
    public void sampleIncludedUpdates() throws Exception {
        LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)schemaDescriptor, (Object[])new Object[]{"foo"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)schemaDescriptor, (Object[])new Object[]{"bar"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)schemaDescriptor, (Object[])new Object[]{"baz"}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)schemaDescriptor, (Object[])new Object[]{"qux"}));
        updates.forEach(arg_0 -> ((UniqueLuceneIndexPopulator)this.populator).includeSample(arg_0));
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(4L, 4L, 4L), (Object)sample);
    }

    @Test
    public void addUpdates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"aaa"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"bbb"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.schemaDescriptor, (Object[])new Object[]{"ccc"}));
        this.populator.add(updates);
        this.index.maybeRefreshBlocking();
        try (IndexReader reader = this.index.getIndexReader();){
            PrimitiveLongResourceIterator allEntities = reader.query(new IndexQuery[]{IndexQuery.exists((int)1)});
            Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])PrimitiveLongCollections.asArray((LongIterator)allEntities));
        }
    }

    private UniqueLuceneIndexPopulator newPopulator() throws IOException {
        UniqueLuceneIndexPopulator populator = new UniqueLuceneIndexPopulator(this.index, descriptor);
        populator.create();
        return populator;
    }

    private static void addUpdate(UniqueLuceneIndexPopulator populator, long nodeId, Object value) throws IOException {
        IndexEntryUpdate update = IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)descriptor.schema(), (Object[])new Object[]{value});
        populator.add(Arrays.asList(update));
    }

    private List<Long> getAllNodes(Directory directory, Object value) throws IOException {
        return AllNodesCollector.getAllNodes(directory, Values.of((Object)value));
    }
}

