/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.LuceneTestUtil;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

class UniqueDatabaseIndexPopulatingUpdaterTest {
    private static final SchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42});

    UniqueDatabaseIndexPopulatingUpdaterTest() {
    }

    @Test
    void closeVerifiesUniquenessOfAddedValues() throws Exception {
        SchemaIndex index = (SchemaIndex)Mockito.mock(SchemaIndex.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"baz"}));
        Mockito.verifyZeroInteractions((Object[])new Object[]{index});
        updater.close();
        this.verifyVerifyUniqueness(index, descriptor, "foo", "bar", "baz");
    }

    @Test
    void closeVerifiesUniquenessOfChangedValues() throws Exception {
        SchemaIndex index = (SchemaIndex)Mockito.mock(SchemaIndex.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index);
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)descriptor, (Object)"foo1", (Object)"foo2"));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)descriptor, (Object)"bar1", (Object)"bar2"));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)descriptor, (Object)"baz1", (Object)"baz2"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{index});
        updater.close();
        this.verifyVerifyUniqueness(index, descriptor, "foo2", "bar2", "baz2");
    }

    @Test
    void closeVerifiesUniquenessOfAddedAndChangedValues() throws Exception {
        SchemaIndex index = (SchemaIndex)Mockito.mock(SchemaIndex.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"added1"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"added2"}));
        updater.process(IndexQueryHelper.change((long)3L, (SchemaDescriptor)descriptor, (Object)"before1", (Object)"after1"));
        updater.process(IndexQueryHelper.change((long)4L, (SchemaDescriptor)descriptor, (Object)"before2", (Object)"after2"));
        updater.process(IndexQueryHelper.remove((long)5L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"removed1"}));
        Mockito.verifyZeroInteractions((Object[])new Object[]{index});
        updater.close();
        this.verifyVerifyUniqueness(index, descriptor, "added1", "added2", "after1", "after2");
    }

    @Test
    void addedNodePropertiesIncludedInSample() throws Exception {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"baz"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"qux"}));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L);
    }

    @Test
    void changedNodePropertiesDoNotInfluenceSample() throws Exception {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)descriptor, (Object)"before1", (Object)"after1"));
        updater.process(IndexQueryHelper.change((long)2L, (SchemaDescriptor)descriptor, (Object)"before2", (Object)"after2"));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 0L);
    }

    @Test
    void removedNodePropertyIncludedInSample() throws Exception {
        long initialValue = 10L;
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        sampler.increment(initialValue);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"removed1"}));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"removed2"}));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, initialValue - 2L);
    }

    @Test
    void nodePropertyUpdatesIncludedInSample() throws Exception {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)descriptor, (Object)"foo", (Object)"bar"));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"baz"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"qux"}));
        updater.process(IndexQueryHelper.remove((long)4L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"qux"}));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 2L);
    }

    @Test
    void additionsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"qux"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), LuceneTestUtil.documentRepresentingProperties(1L, "foo"));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), LuceneTestUtil.documentRepresentingProperties(2L, "bar"));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)3L), LuceneTestUtil.documentRepresentingProperties(3L, "qux"));
    }

    @Test
    void changesDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)descriptor, (Object)"before1", (Object)"after1"));
        updater.process(IndexQueryHelper.change((long)2L, (SchemaDescriptor)descriptor, (Object)"before2", (Object)"after2"));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), LuceneTestUtil.documentRepresentingProperties(1L, "after1"));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), LuceneTestUtil.documentRepresentingProperties(2L, "after2"));
    }

    @Test
    void removalsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.remove((long)3L, (SchemaDescriptor)descriptor, (Object[])new Object[]{"baz"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)3L));
    }

    private static void verifySamplingResult(UniqueIndexSampler sampler, long expectedValue) {
        IndexSample sample = sampler.result();
        Assertions.assertEquals((long)expectedValue, (long)sample.indexSize());
        Assertions.assertEquals((long)expectedValue, (long)sample.uniqueValues());
        Assertions.assertEquals((long)expectedValue, (long)sample.sampleSize());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater() {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(new UniqueIndexSampler());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(SchemaIndex index) {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index, (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class), new UniqueIndexSampler());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(LuceneIndexWriter writer) {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater((SchemaIndex)Mockito.mock(SchemaIndex.class), writer, new UniqueIndexSampler());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(UniqueIndexSampler sampler) {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater((SchemaIndex)Mockito.mock(SchemaIndex.class), (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class), sampler);
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(SchemaIndex index, LuceneIndexWriter writer, UniqueIndexSampler sampler) {
        return new UniqueLuceneIndexPopulatingUpdater(writer, descriptor.getPropertyIds(), index, (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class), sampler);
    }

    private void verifyVerifyUniqueness(SchemaIndex index, SchemaDescriptor descriptor, Object ... values) throws IOException, IndexEntryConflictException {
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((SchemaIndex)Mockito.verify((Object)index)).verifyUniqueness((NodePropertyAccessor)ArgumentMatchers.any(), (int[])ArgumentMatchers.eq((Object)descriptor.getPropertyIds()), (List)captor.capture());
        MatcherAssert.assertThat((Object)captor.getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])LuceneTestUtil.valueTupleList(values).toArray()));
    }
}

