/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class NonUniqueDatabaseIndexPopulatorTest {
    private final DirectoryFactory dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    @Inject
    private TestDirectory testDir;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    private SchemaIndex index;
    private NonUniqueLuceneIndexPopulator populator;
    private final SchemaDescriptor labelSchemaDescriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    NonUniqueDatabaseIndexPopulatorTest() {
    }

    @BeforeEach
    void setUp() {
        File folder = this.testDir.directory("folder");
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(this.dirFactory, (FileSystemAbstraction)this.fileSystem, folder);
        IndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)this.labelSchemaDescriptor);
        this.index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor, (Config)Config.defaults()).withIndexStorage(indexStorage)).build();
    }

    @AfterEach
    void tearDown() throws Exception {
        if (this.populator != null) {
            this.populator.close(false);
        }
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.index, this.dirFactory});
    }

    @Test
    void sampleEmptyIndex() throws IOException {
        this.populator = this.newPopulator();
        IndexSample sample = this.populator.sampleResult();
        Assertions.assertEquals((Object)new IndexSample(), (Object)sample);
    }

    @Test
    void sampleIncludedUpdates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"aaa"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"bbb"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"ccc"}));
        updates.forEach(arg_0 -> ((NonUniqueLuceneIndexPopulator)this.populator).includeSample(arg_0));
        IndexSample sample = this.populator.sampleResult();
        Assertions.assertEquals((Object)new IndexSample(3L, 3L, 3L), (Object)sample);
    }

    @Test
    void sampleIncludedUpdatesWithDuplicates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"foo"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"bar"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"foo"}));
        updates.forEach(arg_0 -> ((NonUniqueLuceneIndexPopulator)this.populator).includeSample(arg_0));
        IndexSample sample = this.populator.sampleResult();
        Assertions.assertEquals((Object)new IndexSample(3L, 2L, 3L), (Object)sample);
    }

    @Test
    void addUpdates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"foo"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"bar"}), IndexQueryHelper.add((long)42L, (SchemaDescriptor)this.labelSchemaDescriptor, (Object[])new Object[]{"bar"}));
        this.populator.add(updates);
        this.index.maybeRefreshBlocking();
        try (IndexReader reader = this.index.getIndexReader();){
            int propertyKeyId = this.labelSchemaDescriptor.getPropertyId();
            PrimitiveLongResourceIterator allEntities = reader.query(new IndexQuery[]{IndexQuery.exists((int)propertyKeyId)});
            Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 42L}, (long[])PrimitiveLongCollections.asArray((LongIterator)allEntities));
        }
    }

    private NonUniqueLuceneIndexPopulator newPopulator() throws IOException {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        NonUniqueLuceneIndexPopulator populator = new NonUniqueLuceneIndexPopulator(this.index, samplingConfig);
        populator.create();
        return populator;
    }
}

