/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.impl.LuceneTestUtil;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

class NonUniqueDatabaseIndexPopulatingUpdaterTest {
    private static final SchemaDescriptor SCHEMA_DESCRIPTOR = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42});
    private static final int SAMPLING_BUFFER_SIZE_LIMIT = 100;
    private static final SchemaDescriptor COMPOSITE_SCHEMA_DESCRIPTOR = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42, 43});

    NonUniqueDatabaseIndexPopulatingUpdaterTest() {
    }

    @Test
    void addedNodePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    void addedNodeCompositePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    void changedNodePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"initial1"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"initial2"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"new2"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object)"initial1", (Object)"new1"));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object)"initial2", (Object)"new2"));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 3L, 2L, 3L);
    }

    @Test
    void changedNodeCompositePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial1"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial2"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "new2"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial1"}, (Object[])new Object[]{"bit", "new1"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial2"}, (Object[])new Object[]{"bit", "new2"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 3L, 2L, 3L);
    }

    @Test
    void removedNodePropertyIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.remove((long)4L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 1L, 1L, 1L);
    }

    @Test
    void removedNodeCompositePropertyIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.remove((long)4L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 1L, 1L, 1L);
    }

    @Test
    void nodePropertyUpdatesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object)"foo", (Object)"newFoo1"));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object)"newFoo1", (Object)"newFoo2"));
        updater.process(IndexQueryHelper.add((long)42L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        updater.process(IndexQueryHelper.add((long)5L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexQueryHelper.remove((long)42L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    void nodeCompositePropertyUpdatesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}, (Object[])new Object[]{"bit", "newFoo1"}));
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "newFoo1"}, (Object[])new Object[]{"bit", "newFoo2"}));
        updater.process(IndexQueryHelper.add((long)42L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        updater.process(IndexQueryHelper.add((long)5L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexQueryHelper.remove((long)42L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    void additionsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        String expectedString1 = LuceneTestUtil.documentRepresentingProperties(1L, "foo").toString();
        String expectedString2 = LuceneTestUtil.documentRepresentingProperties(2L, "bar").toString();
        String expectedString3 = LuceneTestUtil.documentRepresentingProperties(3L, "qux").toString();
        String expectedString4 = LuceneTestUtil.documentRepresentingProperties(4L, "git", "bit").toString();
        updater.process(IndexQueryHelper.add((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), expectedString1);
        updater.process(IndexQueryHelper.add((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), expectedString2);
        updater.process(IndexQueryHelper.add((long)3L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)3L), expectedString3);
        updater.process(IndexQueryHelper.add((long)4L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"git", "bit"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)4L), expectedString4);
    }

    @Test
    void changesDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        String expectedString1 = LuceneTestUtil.documentRepresentingProperties(1L, "after1").toString();
        String expectedString2 = LuceneTestUtil.documentRepresentingProperties(2L, "after2").toString();
        String expectedString3 = LuceneTestUtil.documentRepresentingProperties(3L, "bit", "after2").toString();
        updater.process(IndexQueryHelper.change((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object)"before1", (Object)"after1"));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), expectedString1);
        updater.process(IndexQueryHelper.change((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object)"before2", (Object)"after2"));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), expectedString2);
        updater.process(IndexQueryHelper.change((long)3L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "before2"}, (Object[])new Object[]{"bit", "after2"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)3L), expectedString3);
    }

    @Test
    void removalsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexQueryHelper.remove((long)1L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L));
        updater.process(IndexQueryHelper.remove((long)2L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L));
        updater.process(IndexQueryHelper.remove((long)3L, (SchemaDescriptor)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)3L));
        updater.process(IndexQueryHelper.remove((long)4L, (SchemaDescriptor)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)4L));
    }

    private void verifydocument(LuceneIndexWriter writer, Term eq, String documentString) throws IOException {
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument((Term)ArgumentMatchers.eq((Object)eq), (Document)MockitoHamcrest.argThat((Matcher)Matchers.hasToString((String)documentString)));
    }

    private static void verifySamplingResult(NonUniqueIndexSampler sampler, long expectedIndexSize, long expectedUniqueValues, long expectedSampleSize) {
        IndexSample sample = sampler.result();
        Assertions.assertEquals((long)expectedIndexSize, (long)sample.indexSize());
        Assertions.assertEquals((long)expectedUniqueValues, (long)sample.uniqueValues());
        Assertions.assertEquals((long)expectedSampleSize, (long)sample.sampleSize());
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater(NonUniqueIndexSampler sampler) {
        return NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater((LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class), sampler);
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater(LuceneIndexWriter writer) {
        return NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer, NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler());
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater(LuceneIndexWriter writer, NonUniqueIndexSampler sampler) {
        return new NonUniqueLuceneIndexPopulatingUpdater(writer, sampler);
    }

    private static NonUniqueIndexSampler newSampler() {
        return new DefaultNonUniqueIndexSampler(100);
    }
}

