/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.ReadOnlyDatabaseSchemaIndex;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class ReadOnlyLuceneSchemaIndexTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    private ReadOnlyDatabaseSchemaIndex luceneSchemaIndex;

    ReadOnlyLuceneSchemaIndexTest() {
    }

    @BeforeEach
    void setUp() {
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(DirectoryFactory.PERSISTENT, (FileSystemAbstraction)this.fileSystem, this.testDirectory.directory());
        Config config = Config.defaults();
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
        this.luceneSchemaIndex = new ReadOnlyDatabaseSchemaIndex(indexStorage, TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), samplingConfig, new ReadOnlyIndexPartitionFactory());
    }

    @AfterEach
    void tearDown() throws IOException {
        this.luceneSchemaIndex.close();
    }

    @Test
    void indexDeletionIndReadOnlyModeIsNotSupported() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.luceneSchemaIndex.drop());
    }

    @Test
    void indexCreationInReadOnlyModeIsNotSupported() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.luceneSchemaIndex.create());
    }

    @Test
    void readOnlyIndexMarkingIsNotSupported() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.luceneSchemaIndex.markAsOnline());
    }

    @Test
    void readOnlyIndexMode() {
        Assertions.assertTrue((boolean)this.luceneSchemaIndex.isReadOnly());
    }

    @Test
    void writerIsNotAccessibleInReadOnlyMode() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.luceneSchemaIndex.getIndexWriter());
    }
}

