/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneSchemaIndexTest {
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDir;
    private final DirectoryFactory dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private SchemaIndex index;
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel((int)3, (int[])new int[]{5});

    LuceneSchemaIndexTest() {
    }

    @AfterEach
    void closeIndex() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.index, this.dirFactory});
    }

    @Test
    void markAsOnline() throws IOException {
        this.index = this.createIndex();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        Assertions.assertTrue((boolean)this.index.isOnline(), (String)"Should have had online status set");
    }

    @Test
    void markAsOnlineAndClose() throws IOException {
        this.index = this.createIndex();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        this.index.close();
        this.index = this.openIndex();
        Assertions.assertTrue((boolean)this.index.isOnline(), (String)"Should have had online status set");
    }

    @Test
    void markAsOnlineTwice() throws IOException {
        this.index = this.createIndex();
        this.index.markAsOnline();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        Assertions.assertTrue((boolean)this.index.isOnline(), (String)"Should have had online status set");
    }

    @Test
    void markAsOnlineTwiceAndClose() throws IOException {
        this.index = this.createIndex();
        this.index.markAsOnline();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        this.index.close();
        this.index = this.openIndex();
        Assertions.assertTrue((boolean)this.index.isOnline(), (String)"Should have had online status set");
    }

    @Test
    void markAsOnlineIsRespectedByOtherWriter() throws IOException {
        this.index = this.createIndex();
        this.index.markAsOnline();
        this.index.close();
        this.index = this.openIndex();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.close();
        this.index = this.openIndex();
        Assertions.assertTrue((boolean)this.index.isOnline(), (String)"Should have had online status set");
    }

    private SchemaIndex createIndex() throws IOException {
        SchemaIndex schemaIndex = this.newSchemaIndex();
        schemaIndex.create();
        schemaIndex.open();
        return schemaIndex;
    }

    private SchemaIndex openIndex() throws IOException {
        SchemaIndex schemaIndex = this.newSchemaIndex();
        schemaIndex.open();
        return schemaIndex;
    }

    private SchemaIndex newSchemaIndex() {
        LuceneSchemaIndexBuilder builder = LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)Config.defaults());
        return ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)builder.withIndexRootFolder(new File(this.testDir.directory("index"), "testIndex"))).withDirectoryFactory(this.dirFactory)).withFileSystem((FileSystemAbstraction)this.fs)).build();
    }

    private static Document newDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("test", UUID.randomUUID().toString(), Field.Store.YES));
        return doc;
    }
}

