/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneSchemaIndexIT {
    @Inject
    private TestDirectory testDir;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private final Config config = Config.defaults();

    LuceneSchemaIndexIT() {
    }

    @BeforeEach
    void before() {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "10");
    }

    @AfterEach
    void after() {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
    }

    @Test
    void snapshotForPartitionedIndex() throws Exception {
        try (LuceneIndexAccessor indexAccessor = this.createDefaultIndexAccessor();){
            this.generateUpdates(indexAccessor, 32);
            indexAccessor.force(IOLimiter.UNLIMITED);
            List<String> singlePartitionFileTemplates = Arrays.asList(".cfe", ".cfs", ".si", "segments_1");
            try (ResourceIterator snapshotIterator = indexAccessor.snapshotFiles();){
                List<String> indexFileNames = this.asFileInsidePartitionNames((ResourceIterator<File>)snapshotIterator);
                Assertions.assertTrue((indexFileNames.size() >= singlePartitionFileTemplates.size() * 4 ? 1 : 0) != 0, (String)"Expect files from 4 partitions");
                Map<String, Integer> templateMatches = LuceneSchemaIndexIT.countTemplateMatches(singlePartitionFileTemplates, indexFileNames);
                for (String fileTemplate : singlePartitionFileTemplates) {
                    Integer matches = templateMatches.get(fileTemplate);
                    Assertions.assertTrue((matches >= 4 ? 1 : 0) != 0, (String)("Expect to see at least 4 matches for template: " + fileTemplate));
                }
            }
        }
    }

    @Test
    void snapshotForIndexWithNoCommits() throws Exception {
        try (LuceneIndexAccessor indexAccessor = this.createDefaultIndexAccessor();
             ResourceIterator snapshotIterator = indexAccessor.snapshotFiles();){
            MatcherAssert.assertThat(LuceneSchemaIndexIT.asUniqueSetOfNames((ResourceIterator<File>)snapshotIterator), (Matcher)IsEqual.equalTo(Collections.emptySet()));
        }
    }

    @Test
    void updateMultiplePartitionedIndex() throws IOException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)this.config).withFileSystem((FileSystemAbstraction)this.fileSystem)).withIndexRootFolder(this.testDir.directory("partitionedIndexForUpdates"))).build();){
            index.create();
            index.open();
            this.addDocumentToIndex(index, 45);
            index.getIndexWriter().updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)100L), LuceneDocumentStructure.documentRepresentingProperties((long)100L, (Value[])new Value[]{Values.intValue((int)100)}));
            index.maybeRefreshBlocking();
            long documentsInIndex = Iterators.count((Iterator)index.allDocumentsReader().iterator());
            Assertions.assertEquals((long)46L, (long)documentsInIndex, (String)"Index should contain 45 added and 1 updated document.");
        }
    }

    @Test
    void createPopulateDropIndex() throws Exception {
        File crudOperation = this.testDir.directory("indexCRUDOperation");
        try (SchemaIndex crudIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)this.config).withFileSystem((FileSystemAbstraction)this.fileSystem)).withIndexRootFolder(new File(crudOperation, "crudIndex"))).build();){
            crudIndex.open();
            this.addDocumentToIndex(crudIndex, 1);
            Assertions.assertEquals((int)1, (int)crudIndex.getPartitions().size());
            this.addDocumentToIndex(crudIndex, 21);
            Assertions.assertEquals((int)3, (int)crudIndex.getPartitions().size());
            crudIndex.drop();
            Assertions.assertFalse((boolean)crudIndex.isOpen());
            Assertions.assertEquals((int)0, (int)crudOperation.list().length);
        }
    }

    @Test
    void createFailPartitionedIndex() throws Exception {
        try (SchemaIndex failedIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)this.config).withFileSystem((FileSystemAbstraction)this.fileSystem)).withIndexRootFolder(new File(this.testDir.directory("failedIndexFolder"), "failedIndex"))).build();){
            failedIndex.open();
            this.addDocumentToIndex(failedIndex, 35);
            Assertions.assertEquals((int)4, (int)failedIndex.getPartitions().size());
            failedIndex.markAsFailed("Some failure");
            failedIndex.flush();
            Assertions.assertTrue((boolean)failedIndex.isOpen());
            Assertions.assertFalse((boolean)failedIndex.isOnline());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void openClosePartitionedIndex() throws IOException {
        try (SchemaIndex reopenIndex = null;){
            reopenIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)this.config).withFileSystem((FileSystemAbstraction)this.fileSystem)).withIndexRootFolder(new File(this.testDir.directory("reopenIndexFolder"), "reopenIndex"))).build();
            reopenIndex.open();
            this.addDocumentToIndex(reopenIndex, 1);
            reopenIndex.close();
            Assertions.assertFalse((boolean)reopenIndex.isOpen());
            reopenIndex.open();
            Assertions.assertTrue((boolean)reopenIndex.isOpen());
            this.addDocumentToIndex(reopenIndex, 10);
            reopenIndex.close();
            Assertions.assertFalse((boolean)reopenIndex.isOpen());
            reopenIndex.open();
            Assertions.assertTrue((boolean)reopenIndex.isOpen());
            reopenIndex.close();
            reopenIndex.open();
            this.addDocumentToIndex(reopenIndex, 100);
            reopenIndex.maybeRefreshBlocking();
            try (LuceneAllDocumentsReader allDocumentsReader = reopenIndex.allDocumentsReader();){
                Assertions.assertEquals((long)111L, (long)allDocumentsReader.maxCount(), (String)"All documents should be visible");
            }
        }
    }

    private void addDocumentToIndex(SchemaIndex index, int documents) throws IOException {
        for (int i = 0; i < documents; ++i) {
            index.getIndexWriter().addDocument(LuceneDocumentStructure.documentRepresentingProperties((long)i, (Value[])new Value[]{Values.intValue((int)i)}));
        }
    }

    private LuceneIndexAccessor createDefaultIndexAccessor() throws IOException {
        SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)this.config).withFileSystem((FileSystemAbstraction)this.fileSystem)).withIndexRootFolder(this.testDir.directory("testIndex"))).build();
        index.create();
        index.open();
        return new LuceneIndexAccessor(index, this.descriptor);
    }

    private List<String> asFileInsidePartitionNames(ResourceIterator<File> resources) {
        int testDirectoryPathLength = this.testDir.directory().getAbsolutePath().length();
        return Iterators.asList(resources).stream().map(file -> file.getAbsolutePath().substring(testDirectoryPathLength)).collect(Collectors.toList());
    }

    private void generateUpdates(LuceneIndexAccessor indexAccessor, int nodesToUpdate) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = indexAccessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (int nodeId = 0; nodeId < nodesToUpdate; ++nodeId) {
                updater.process(this.add(nodeId, nodeId));
            }
        }
    }

    private IndexEntryUpdate<?> add(long nodeId, Object value) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{Values.of((Object)value)});
    }

    private static Map<String, Integer> countTemplateMatches(List<String> nameTemplates, List<String> fileNames) {
        HashMap<String, Integer> templateMatches = new HashMap<String, Integer>();
        for (String indexFileName : fileNames) {
            for (String template : nameTemplates) {
                if (!indexFileName.endsWith(template)) continue;
                templateMatches.put(template, templateMatches.getOrDefault(template, 0) + 1);
            }
        }
        return templateMatches;
    }

    private static Set<String> asUniqueSetOfNames(ResourceIterator<File> files) {
        ArrayList<String> out = new ArrayList<String>();
        while (files.hasNext()) {
            String name = ((File)files.next()).getName();
            out.add(name);
        }
        return Iterables.asUniqueSet(out);
    }
}

