/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.CorruptIndexException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={EphemeralFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneSchemaIndexCorruptionTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private EphemeralFileSystemAbstraction fs;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final IndexProvider.Monitor monitor = new LoggingMonitor(this.logProvider.getLog("test"));

    LuceneSchemaIndexCorruptionTest() {
    }

    @Test
    void shouldRequestIndexPopulationIfTheIndexIsCorrupt() {
        long faultyIndexId = 1L;
        CorruptIndexException error = new CorruptIndexException("It's broken.", "");
        LuceneIndexProvider provider = this.newFaultyIndexProvider(faultyIndexId, (Exception)error);
        StoreIndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)provider.getProviderDescriptor()).withId(faultyIndexId);
        InternalIndexState initialState = provider.getInitialState(descriptor);
        MatcherAssert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException((Throwable)error)});
    }

    @Test
    void shouldRequestIndexPopulationFailingWithFileNotFoundException() {
        long faultyIndexId = 1L;
        FileNotFoundException error = new FileNotFoundException("/some/path/somewhere");
        LuceneIndexProvider provider = this.newFaultyIndexProvider(faultyIndexId, error);
        StoreIndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)provider.getProviderDescriptor()).withId(faultyIndexId);
        InternalIndexState initialState = provider.getInitialState(descriptor);
        MatcherAssert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException(error)});
    }

    @Test
    void shouldRequestIndexPopulationWhenFailingWithEOFException() {
        long faultyIndexId = 1L;
        EOFException error = new EOFException("/some/path/somewhere");
        LuceneIndexProvider provider = this.newFaultyIndexProvider(faultyIndexId, error);
        StoreIndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)provider.getProviderDescriptor()).withId(faultyIndexId);
        InternalIndexState initialState = provider.getInitialState(descriptor);
        MatcherAssert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException(error)});
    }

    private LuceneIndexProvider newFaultyIndexProvider(final long faultyIndexId, final Exception error) {
        DirectoryFactory directoryFactory = (DirectoryFactory)Mockito.mock(DirectoryFactory.class);
        File indexRootFolder = this.testDirectory.databaseDir();
        final AtomicReference reference = new AtomicReference();
        return new LuceneIndexProvider((FileSystemAbstraction)this.fs, directoryFactory, LuceneIndexProvider.defaultDirectoryStructure((File)indexRootFolder), this.monitor, Config.defaults(), OperationalMode.single){

            protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
                FaultyIndexStorageFactory storageFactory = new FaultyIndexStorageFactory(faultyIndexId, error, directoryFactory, this.directoryStructure());
                reference.set(storageFactory);
                return storageFactory;
            }
        };
    }

    private static AssertableLogProvider.LogMatcher loggedException(Throwable exception) {
        return AssertableLogProvider.inLog((Matcher)CoreMatchers.any(String.class)).error(CoreMatchers.any(String.class), CoreMatchers.sameInstance((Object)exception));
    }

    private class FaultyIndexStorageFactory
    extends IndexStorageFactory {
        final long faultyIndexId;
        final Exception error;

        FaultyIndexStorageFactory(long faultyIndexId, Exception error, DirectoryFactory directoryFactory, IndexDirectoryStructure directoryStructure) {
            super(directoryFactory, (FileSystemAbstraction)LuceneSchemaIndexCorruptionTest.this.fs, directoryStructure);
            this.faultyIndexId = faultyIndexId;
            this.error = error;
        }

        public PartitionedIndexStorage indexStorageOf(long indexId) {
            return indexId == this.faultyIndexId ? this.newFaultyPartitionedIndexStorage() : super.indexStorageOf(indexId);
        }

        PartitionedIndexStorage newFaultyPartitionedIndexStorage() {
            try {
                PartitionedIndexStorage storage = (PartitionedIndexStorage)Mockito.mock(PartitionedIndexStorage.class);
                Mockito.when((Object)storage.listFolders()).thenReturn(Collections.singletonList(new File("/some/path/somewhere/1")));
                Mockito.when((Object)storage.openDirectory((File)ArgumentMatchers.any())).thenThrow(new Throwable[]{this.error});
                return storage;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

