/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneSchemaIndexBuilderTest {
    @Inject
    private TestDirectory testDir;
    @Inject
    private DefaultFileSystemAbstraction fileSystemRule;
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    LuceneSchemaIndexBuilderTest() {
    }

    @Test
    void readOnlyIndexCreation() throws Exception {
        try (SchemaIndex schemaIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)LuceneSchemaIndexBuilderTest.getReadOnlyConfig()).withFileSystem((FileSystemAbstraction)this.fileSystemRule)).withOperationalMode(OperationalMode.single)).withIndexRootFolder(this.testDir.directory("a"))).build();){
            Assertions.assertTrue((boolean)schemaIndex.isReadOnly(), (String)"Builder should construct read only index.");
        }
    }

    @Test
    void writableIndexCreation() throws Exception {
        try (SchemaIndex schemaIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)LuceneSchemaIndexBuilderTest.getDefaultConfig()).withFileSystem((FileSystemAbstraction)this.fileSystemRule)).withOperationalMode(OperationalMode.single)).withIndexRootFolder(this.testDir.directory("b"))).build();){
            Assertions.assertFalse((boolean)schemaIndex.isReadOnly(), (String)"Builder should construct writable index.");
        }
    }

    private static Config getDefaultConfig() {
        return Config.defaults();
    }

    private static Config getReadOnlyConfig() {
        return Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
    }
}

