/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneIndexProviderTest {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDir;
    private File graphDbDir;
    private static final StoreIndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(1L);

    LuceneIndexProviderTest() {
    }

    @BeforeEach
    void setup() {
        this.graphDbDir = this.testDir.databaseDir();
    }

    @Test
    void shouldFailToInvokePopulatorInReadOnlyMode() {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), (FileSystemAbstraction)this.fileSystem, this.graphDbDir);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readOnlyIndexProvider.getPopulator(descriptor, new IndexSamplingConfig(readOnlyConfig)));
    }

    @Test
    void shouldCreateReadOnlyAccessorInReadOnlyMode() throws Exception {
        DirectoryFactory directoryFactory = DirectoryFactory.PERSISTENT;
        this.createEmptySchemaIndex(directoryFactory);
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, directoryFactory, (FileSystemAbstraction)this.fileSystem, this.graphDbDir);
        IndexAccessor onlineAccessor = this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((IndexAccessor)onlineAccessor).drop());
    }

    @Test
    void indexUpdateNotAllowedInReadOnlyMode() throws Exception {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), (FileSystemAbstraction)this.fileSystem, this.graphDbDir);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider).newUpdater(IndexUpdateMode.ONLINE));
    }

    @Test
    void indexForceMustBeAllowedInReadOnlyMode() throws Exception {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), (FileSystemAbstraction)this.fileSystem, this.graphDbDir);
        this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider).force(IOLimiter.UNLIMITED);
    }

    private void createEmptySchemaIndex(DirectoryFactory directoryFactory) throws IOException {
        Config config = Config.defaults();
        LuceneIndexProvider indexProvider = this.getLuceneIndexProvider(config, directoryFactory, (FileSystemAbstraction)this.fileSystem, this.graphDbDir);
        IndexAccessor onlineAccessor = this.getIndexAccessor(config, indexProvider);
        onlineAccessor.close();
    }

    private IndexAccessor getIndexAccessor(Config readOnlyConfig, LuceneIndexProvider indexProvider) throws IOException {
        return indexProvider.getOnlineAccessor(descriptor, new IndexSamplingConfig(readOnlyConfig));
    }

    private LuceneIndexProvider getLuceneIndexProvider(Config config, DirectoryFactory directoryFactory, FileSystemAbstraction fs, File graphDbDir) {
        return new LuceneIndexProvider(fs, directoryFactory, LuceneIndexProvider.defaultDirectoryStructure((File)graphDbDir), IndexProvider.Monitor.EMPTY, config, OperationalMode.single);
    }
}

