/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.impl.LuceneTestUtil;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;

class LuceneDocumentStructureTest {
    LuceneDocumentStructureTest() {
    }

    @Test
    void stringWithMaximumLengthShouldBeAllowed() {
        String longestString = RandomStringUtils.randomAscii((int)32766);
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, longestString);
        Assertions.assertEquals((Object)longestString, (Object)document.getField(ValueEncoding.String.key(0)).stringValue());
    }

    @Test
    void shouldBuildDocumentRepresentingStringProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, "hello");
        Assertions.assertEquals((Object)"123", (Object)document.get("id"));
        Assertions.assertEquals((Object)"hello", (Object)document.get(ValueEncoding.String.key(0)));
    }

    @Test
    void shouldBuildDocumentRepresentingMultipleStringProperties() {
        Object[] values = new String[]{"hello", "world"};
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, values);
        Assertions.assertEquals((Object)"123", (Object)document.get("id"));
        MatcherAssert.assertThat((Object)document.get(ValueEncoding.String.key(0)), (Matcher)CoreMatchers.equalTo((Object)values[0]));
        MatcherAssert.assertThat((Object)document.get(ValueEncoding.String.key(1)), (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    void shouldBuildDocumentRepresentingMultiplePropertiesOfDifferentTypes() {
        Object[] values = new Object[]{"hello", 789};
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, values);
        Assertions.assertEquals((Object)"123", (Object)document.get("id"));
        MatcherAssert.assertThat((Object)document.get(ValueEncoding.String.key(0)), (Matcher)CoreMatchers.equalTo((Object)"hello"));
        MatcherAssert.assertThat((Object)document.get(ValueEncoding.Number.key(1)), (Matcher)CoreMatchers.equalTo((Object)"789.0"));
    }

    @Test
    void shouldBuildDocumentRepresentingBoolProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, true);
        Assertions.assertEquals((Object)"123", (Object)document.get("id"));
        Assertions.assertEquals((Object)"true", (Object)document.get(ValueEncoding.Bool.key(0)));
    }

    @Test
    void shouldBuildDocumentRepresentingNumberProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, 12);
        Assertions.assertEquals((Object)"123", (Object)document.get("id"));
        Assertions.assertEquals((double)12.0, (double)document.getField(ValueEncoding.Number.key(0)).numericValue().doubleValue(), (double)0.001);
    }

    @Test
    void shouldBuildDocumentRepresentingArrayProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, new Object[]{new Integer[]{1, 2, 3}});
        Assertions.assertEquals((Object)"123", (Object)document.get("id"));
        Assertions.assertEquals((Object)"D1.0|2.0|3.0|", (Object)document.get(ValueEncoding.Array.key(0)));
    }

    @Test
    void shouldBuildQueryRepresentingBoolProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(true);
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery query = (TermQuery)constantScoreQuery.getQuery();
        Assertions.assertEquals((Object)"true", (Object)query.getTerm().text());
    }

    @Test
    void shouldBuildQueryRepresentingStringProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery("Characters");
        ConstantScoreQuery query = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        Assertions.assertEquals((Object)"Characters", (Object)((TermQuery)query.getQuery()).getTerm().text());
    }

    @Test
    void shouldBuildQueryRepresentingNumberProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(12);
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        NumericRangeQuery query = (NumericRangeQuery)constantScoreQuery.getQuery();
        Assertions.assertEquals((double)12.0, (double)((Double)query.getMin()), (double)0.001);
        Assertions.assertEquals((double)12.0, (double)((Double)query.getMax()), (double)0.001);
    }

    @Test
    void shouldBuildQueryRepresentingArrayProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(new Object[]{new Integer[]{1, 2, 3}});
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery query = (TermQuery)constantScoreQuery.getQuery();
        Assertions.assertEquals((Object)"D1.0|2.0|3.0|", (Object)query.getTerm().text());
    }

    @Test
    void shouldBuildQueryRepresentingMultipleProperties() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(true, "Characters", 12, new Integer[]{1, 2, 3});
        ConstantScoreQuery boolScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery boolTermQuery = (TermQuery)boolScoreQuery.getQuery();
        ConstantScoreQuery stringScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(1)).getQuery();
        TermQuery stringTermQuery = (TermQuery)stringScoreQuery.getQuery();
        ConstantScoreQuery numberScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(2)).getQuery();
        NumericRangeQuery numericRangeQuery = (NumericRangeQuery)numberScoreQuery.getQuery();
        ConstantScoreQuery arrayScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(3)).getQuery();
        TermQuery arrayTermQuery = (TermQuery)arrayScoreQuery.getQuery();
        Assertions.assertEquals((Object)"true", (Object)boolTermQuery.getTerm().text());
        Assertions.assertEquals((Object)"Characters", (Object)stringTermQuery.getTerm().text());
        Assertions.assertEquals((double)12.0, (double)((Double)numericRangeQuery.getMin()), (double)0.001);
        Assertions.assertEquals((double)12.0, (double)((Double)numericRangeQuery.getMax()), (double)0.001);
        Assertions.assertEquals((Object)"D1.0|2.0|3.0|", (Object)arrayTermQuery.getTerm().text());
    }

    @Test
    void shouldBuildRangeSeekByNumberQueryForStrings() {
        NumericRangeQuery query = LuceneDocumentStructure.newInclusiveNumericRangeSeekQuery((Number)12.0, null);
        Assertions.assertEquals((Object)"number", (Object)query.getField());
        Assertions.assertEquals((double)12.0, (double)((Double)query.getMin()), (double)0.001);
        Assertions.assertTrue((boolean)query.includesMin());
        Assertions.assertNull((Object)query.getMax());
        Assertions.assertTrue((boolean)query.includesMax());
    }

    @Test
    void shouldBuildRangeSeekByStringQueryForStrings() {
        TermRangeQuery query = (TermRangeQuery)LuceneDocumentStructure.newRangeSeekByStringQuery((String)"foo", (boolean)false, null, (boolean)true);
        Assertions.assertEquals((Object)"string", (Object)query.getField());
        Assertions.assertEquals((Object)"foo", (Object)query.getLowerTerm().utf8ToString());
        Assertions.assertFalse((boolean)query.includesLower());
        Assertions.assertNull((Object)query.getUpperTerm());
        Assertions.assertTrue((boolean)query.includesUpper());
    }

    @Test
    void shouldBuildWildcardQueries() {
        WildcardQuery query = (WildcardQuery)LuceneDocumentStructure.newWildCardStringQuery((String)"foo");
        Assertions.assertEquals((Object)"string", (Object)query.getField());
    }

    @Test
    void shouldBuildRangeSeekByPrefixQueryForStrings() {
        MultiTermQuery prefixQuery = (MultiTermQuery)LuceneDocumentStructure.newRangeSeekByPrefixQuery((String)"Prefix");
        MatcherAssert.assertThat((String)"Should contain term value", (Object)prefixQuery.toString(), (Matcher)Matchers.containsString((String)"Prefix"));
    }

    @Test
    void checkFieldUsageForUniquenessVerification() {
        Assertions.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"id"));
        Assertions.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"1number"));
        Assertions.assertTrue((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"number"));
        Assertions.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"1string"));
        Assertions.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"10string"));
        Assertions.assertTrue((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"string"));
    }
}

