/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class LongArrayMatcher
extends TypeSafeDiagnosingMatcher<long[]> {
    private long[] expectedArray;

    public static LongArrayMatcher emptyArrayMatcher() {
        return new LongArrayMatcher(new long[0]);
    }

    public static LongArrayMatcher of(long ... values) {
        return new LongArrayMatcher(values);
    }

    LongArrayMatcher(long[] expectedArray) {
        this.expectedArray = expectedArray;
    }

    protected boolean matchesSafely(long[] items, Description mismatchDescription) {
        this.describeArray(items, mismatchDescription);
        if (items.length != this.expectedArray.length) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == this.expectedArray[i]) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        this.describeArray(this.expectedArray, description);
    }

    private void describeArray(long[] value, Description description) {
        description.appendText("long[]").appendText(Arrays.toString(value));
    }
}

