/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.AllNodesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class AccessUniqueDatabaseIndexTest {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;
    private final DirectoryFactory directoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private final File storeDirectory = new File("db");
    private final IndexDescriptor index = TestIndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100});

    AccessUniqueDatabaseIndexTest() {
    }

    @Test
    void shouldAddUniqueEntries() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1"), this.add(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(3L, "value3")));
        accessor.close();
        Assertions.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value1"));
    }

    @Test
    void shouldUpdateUniqueEntries() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.change(1L, "value1", "value2")));
        accessor.close();
        Assertions.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value2"));
        Assertions.assertEquals(Collections.emptyList(), this.getAllNodes(indexStorage, "value1"));
    }

    @Test
    void shouldRemoveAndAddEntries() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(3L, "value3")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(4L, "value4")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.remove(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.remove(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.remove(3L, "value3")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(3L, "value3b")));
        accessor.close();
        Assertions.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value1"));
        Assertions.assertEquals(Collections.emptyList(), this.getAllNodes(indexStorage, "value2"));
        Assertions.assertEquals(Collections.emptyList(), this.getAllNodes(indexStorage, "value3"));
        Assertions.assertEquals(Arrays.asList(3L), this.getAllNodes(indexStorage, "value3b"));
        Assertions.assertEquals(Arrays.asList(4L), this.getAllNodes(indexStorage, "value4"));
    }

    @Test
    void shouldConsiderWholeTransactionForValidatingUniqueness() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.change(1L, "value1", "value2"), this.change(2L, "value2", "value1")));
        accessor.close();
        Assertions.assertEquals(Arrays.asList(2L), this.getAllNodes(indexStorage, "value1"));
        Assertions.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value2"));
    }

    private LuceneIndexAccessor createAccessor(PartitionedIndexStorage indexStorage) throws IOException {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.index, (Config)Config.defaults()).withIndexStorage(indexStorage)).build();
        luceneIndex.open();
        return new LuceneIndexAccessor(luceneIndex, this.index);
    }

    private PartitionedIndexStorage getIndexStorage() {
        IndexStorageFactory storageFactory = new IndexStorageFactory(this.directoryFactory, (FileSystemAbstraction)this.fileSystem, IndexDirectoryStructure.directoriesByProviderKey((File)this.storeDirectory).forProvider(LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR));
        return storageFactory.indexStorageOf(1L);
    }

    private IndexEntryUpdate<?> add(long nodeId, Object propertyValue) {
        return IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)this.index.schema(), (Object[])new Object[]{propertyValue});
    }

    private IndexEntryUpdate<?> change(long nodeId, Object oldValue, Object newValue) {
        return IndexQueryHelper.change((long)nodeId, (SchemaDescriptor)this.index.schema(), (Object)oldValue, (Object)newValue);
    }

    private IndexEntryUpdate<?> remove(long nodeId, Object oldValue) {
        return IndexQueryHelper.remove((long)nodeId, (SchemaDescriptor)this.index.schema(), (Object[])new Object[]{oldValue});
    }

    private List<Long> getAllNodes(PartitionedIndexStorage indexStorage, String propertyValue) throws IOException {
        return AllNodesCollector.getAllNodes(indexStorage.openDirectory(indexStorage.getPartitionFolder(1)), (Value)Values.stringValue((String)propertyValue));
    }

    private void updateAndCommit(IndexAccessor accessor, Iterable<IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
    }
}

