/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.verification;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.LuceneTestUtil;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.TestPropertyAccessor;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.SimpleUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={TestDirectoryExtension.class})
class SimpleUniquenessVerifierTest {
    private static final int[] PROPERTY_KEY_IDS = new int[]{42};
    @Inject
    private TestDirectory testDir;
    private DirectoryFactory dirFactory;
    private IndexWriter writer;
    private SearcherManager searcherManager;

    SimpleUniquenessVerifierTest() {
    }

    @BeforeEach
    void initLuceneResources() throws Exception {
        this.dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
        Directory dir = this.dirFactory.open(this.testDir.directory("test"));
        this.writer = new IndexWriter(dir, IndexWriterConfigs.standard());
        this.searcherManager = new SearcherManager(this.writer, true, new SearcherFactory());
    }

    @AfterEach
    void closeLuceneResources() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.searcherManager, this.writer, this.dirFactory});
    }

    @Test
    void partitionSearcherIsClosed() throws IOException {
        PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
        SimpleUniquenessVerifier verifier = new SimpleUniquenessVerifier(partitionSearcher);
        verifier.close();
        ((PartitionSearcher)Mockito.verify((Object)partitionSearcher)).close();
    }

    @Test
    void populationVerificationNoDuplicates() throws Exception {
        List<Object> data = Arrays.asList("string1", 42, 43, 44, 45L, (byte)46, 47.0, Float.valueOf(48.1f), "string2");
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertNoDuplicates(nodePropertyAccessor);
    }

    @Test
    void populationVerificationOneDuplicate() throws IOException {
        List<Object> data = Arrays.asList("cat", 21, 22, 23, 24L, (byte)25, 26.0, Float.valueOf(22.0f), "dog");
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertHasDuplicates(nodePropertyAccessor);
    }

    @Test
    void populationVerificationManyDuplicate() throws IOException {
        List<Object> data = Arrays.asList("dog", "cat", "dog", "dog", "dog", "dog");
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertHasDuplicates(nodePropertyAccessor);
    }

    @Test
    void updatesVerificationNoDuplicates() throws Exception {
        List<Object> data = Arrays.asList("lucene", 1337975550, 43.1, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), (byte)12);
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertNoDuplicatesCreated(nodePropertyAccessor, LuceneTestUtil.valueTupleList(1337975550, Character.valueOf('c'), (byte)12));
    }

    @Test
    void updatesVerificationOneDuplicate() throws IOException {
        List<Object> data = Arrays.asList("foo", "bar", "baz", 100, 200, Character.valueOf('q'), Character.valueOf('u'), Character.valueOf('x'), "aa", 300, Character.valueOf('u'), -100);
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertDuplicatesCreated(nodePropertyAccessor, LuceneTestUtil.valueTupleList("aa", Character.valueOf('u'), -100));
    }

    @Test
    void updatesVerificationManyDuplicate() throws IOException {
        List<Object> data = Arrays.asList(-99, Character.valueOf('a'), -10.0, -99.99999, "apa", Float.valueOf(-99.99999f), "mod", "div", "div", -10);
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertDuplicatesCreated(nodePropertyAccessor, LuceneTestUtil.valueTupleList(Float.valueOf(-99.99999f), Character.valueOf('a'), -10, "div"));
    }

    @Test
    void numericIndexVerificationNoDuplicates() throws Exception {
        List<Object> data = Arrays.asList(0x7FFFFFFD, 0x7FFFFFFE, Integer.MAX_VALUE);
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.spy((Object)this.searcherManager.acquire());
        this.runUniquenessVerification(nodePropertyAccessor, indexSearcher);
        ((IndexSearcher)Mockito.verify((Object)indexSearcher, (VerificationMode)Mockito.never())).search((Query)ArgumentMatchers.any(Query.class), (Collector)ArgumentMatchers.any(Collector.class));
    }

    @Test
    void numericIndexVerificationSomePossibleDuplicates() throws Exception {
        List<Object> data = Arrays.asList(42, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.spy((Object)this.searcherManager.acquire());
        this.runUniquenessVerification(nodePropertyAccessor, indexSearcher);
        ((IndexSearcher)Mockito.verify((Object)indexSearcher)).search((Query)ArgumentMatchers.any(Query.class), (Collector)ArgumentMatchers.any(Collector.class));
    }

    @Test
    void numericIndexVerificationSomeWithDuplicates() throws Exception {
        List<Object> data = Arrays.asList(Integer.MAX_VALUE, Long.MAX_VALUE, 42, Long.MAX_VALUE);
        NodePropertyAccessor nodePropertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.spy((Object)this.searcherManager.acquire());
        Assertions.assertThrows(IndexEntryConflictException.class, () -> this.runUniquenessVerification(nodePropertyAccessor, indexSearcher));
        ((IndexSearcher)Mockito.verify((Object)indexSearcher)).search((Query)ArgumentMatchers.any(Query.class), (Collector)ArgumentMatchers.any(Collector.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUniquenessVerification(NodePropertyAccessor nodePropertyAccessor, IndexSearcher indexSearcher) throws IOException, IndexEntryConflictException {
        try {
            PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
            Mockito.when((Object)partitionSearcher.getIndexSearcher()).thenReturn((Object)indexSearcher);
            try (SimpleUniquenessVerifier verifier = new SimpleUniquenessVerifier(partitionSearcher);){
                verifier.verify(nodePropertyAccessor, PROPERTY_KEY_IDS);
            }
        }
        finally {
            this.searcherManager.release((Object)indexSearcher);
        }
    }

    private void assertNoDuplicates(NodePropertyAccessor nodePropertyAccessor) throws Exception {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            verifier.verify(nodePropertyAccessor, PROPERTY_KEY_IDS);
        }
    }

    private void assertNoDuplicatesCreated(NodePropertyAccessor nodePropertyAccessor, List<Value[]> updatedPropertyValues) throws Exception {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            verifier.verify(nodePropertyAccessor, PROPERTY_KEY_IDS, updatedPropertyValues);
        }
    }

    private void assertHasDuplicates(NodePropertyAccessor nodePropertyAccessor) throws IOException {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            Assertions.assertThrows(IndexEntryConflictException.class, () -> verifier.verify(nodePropertyAccessor, PROPERTY_KEY_IDS));
        }
    }

    private void assertDuplicatesCreated(NodePropertyAccessor nodePropertyAccessor, List<Value[]> updatedPropertyValues) throws IOException {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            Assertions.assertThrows(IndexEntryConflictException.class, () -> verifier.verify(nodePropertyAccessor, PROPERTY_KEY_IDS, updatedPropertyValues));
        }
    }

    private void insert(List<Object> data) throws IOException {
        for (int i = 0; i < data.size(); ++i) {
            Document doc = LuceneDocumentStructure.documentRepresentingProperties((long)i, (Value[])new Value[]{Values.of((Object)data.get(i))});
            this.writer.addDocument((Iterable)doc);
        }
        this.searcherManager.maybeRefreshBlocking();
    }

    private NodePropertyAccessor newPropertyAccessor(List<Object> propertyValues) {
        return new TestPropertyAccessor(propertyValues.stream().map(Values::of).collect(Collectors.toList()));
    }

    private UniquenessVerifier newSimpleUniquenessVerifier() throws IOException {
        PartitionSearcher partitionSearcher = new PartitionSearcher((ReferenceManager)this.searcherManager);
        return new SimpleUniquenessVerifier(partitionSearcher);
    }
}

