/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage.layout;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;

class IndexFolderLayoutTest {
    private final File indexRoot = new File("indexRoot");

    IndexFolderLayoutTest() {
    }

    @Test
    void testIndexFolder() {
        IndexFolderLayout indexLayout = this.createTestIndex();
        File indexFolder = indexLayout.getIndexFolder();
        Assertions.assertEquals((Object)this.indexRoot, (Object)indexFolder);
    }

    @Test
    void testIndexPartitionFolder() {
        IndexFolderLayout indexLayout = this.createTestIndex();
        File indexFolder = indexLayout.getIndexFolder();
        File partitionFolder1 = indexLayout.getPartitionFolder(1);
        File partitionFolder3 = indexLayout.getPartitionFolder(3);
        Assertions.assertEquals((Object)partitionFolder1.getParentFile(), (Object)partitionFolder3.getParentFile());
        Assertions.assertEquals((Object)indexFolder, (Object)partitionFolder1.getParentFile());
        Assertions.assertEquals((Object)"1", (Object)partitionFolder1.getName());
        Assertions.assertEquals((Object)"3", (Object)partitionFolder3.getName());
    }

    private IndexFolderLayout createTestIndex() {
        return new IndexFolderLayout(this.indexRoot);
    }
}

