/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class PartitionedIndexStorageTest {
    private static final DirectoryFactory.InMemoryDirectoryFactory directoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDir;
    private PartitionedIndexStorage storage;

    PartitionedIndexStorageTest() {
    }

    @BeforeEach
    void createIndexStorage() {
        this.storage = new PartitionedIndexStorage((DirectoryFactory)directoryFactory, (FileSystemAbstraction)this.fs, this.testDir.databaseDir());
    }

    @Test
    void prepareFolderCreatesFolder() throws IOException {
        File folder = this.createRandomFolder(this.testDir.databaseDir());
        this.storage.prepareFolder(folder);
        Assertions.assertTrue((boolean)this.fs.fileExists(folder));
    }

    @Test
    void prepareFolderRemovesFromFileSystem() throws IOException {
        File folder = this.createRandomFolder(this.testDir.databaseDir());
        this.createRandomFilesAndFolders(folder);
        this.storage.prepareFolder(folder);
        Assertions.assertTrue((boolean)this.fs.fileExists(folder));
        Assertions.assertTrue((boolean)ArrayUtil.isEmpty((Object[])this.fs.listFiles(folder)));
    }

    @Test
    void prepareFolderRemovesFromLucene() throws IOException {
        File folder = this.createRandomFolder(this.testDir.databaseDir());
        Directory dir = this.createRandomLuceneDir(folder);
        Assertions.assertFalse((boolean)ArrayUtil.isEmpty((Object[])dir.listAll()));
        this.storage.prepareFolder(folder);
        Assertions.assertTrue((boolean)this.fs.fileExists(folder));
        Assertions.assertTrue((boolean)ArrayUtil.isEmpty((Object[])dir.listAll()));
    }

    @Test
    void openIndexDirectoriesForEmptyIndex() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        Map directories = this.storage.openIndexDirectories();
        Assertions.assertTrue((boolean)directories.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void openIndexDirectories() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        this.createRandomLuceneDir(indexFolder).close();
        this.createRandomLuceneDir(indexFolder).close();
        Map directories = this.storage.openIndexDirectories();
        try {
            Assertions.assertEquals((int)2, (int)directories.size());
            for (Directory dir : directories.values()) {
                Assertions.assertFalse((boolean)ArrayUtil.isEmpty((Object[])dir.listAll()));
            }
        }
        finally {
            IOUtils.closeAll(directories.values());
        }
    }

    @Test
    void listFoldersForEmptyFolder() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        this.fs.mkdirs(indexFolder);
        List folders = this.storage.listFolders();
        Assertions.assertTrue((boolean)folders.isEmpty());
    }

    @Test
    void listFolders() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        this.fs.mkdirs(indexFolder);
        this.createRandomFile(indexFolder);
        this.createRandomFile(indexFolder);
        File folder1 = this.createRandomFolder(indexFolder);
        File folder2 = this.createRandomFolder(indexFolder);
        List folders = this.storage.listFolders();
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new File[]{folder1, folder2}), new HashSet(folders));
    }

    @Test
    void shouldListIndexPartitionsSorted() throws Exception {
        try (DefaultFileSystemAbstraction scramblingFs = new DefaultFileSystemAbstraction(){

            public File[] listFiles(File directory) {
                List<File> files = Arrays.asList(super.listFiles(directory));
                Collections.shuffle(files);
                return files.toArray(new File[files.size()]);
            }
        };){
            PartitionedIndexStorage myStorage = new PartitionedIndexStorage((DirectoryFactory)directoryFactory, (FileSystemAbstraction)scramblingFs, this.testDir.databaseDir());
            File parent = myStorage.getIndexFolder();
            int directoryCount = 10;
            for (int i = 0; i < directoryCount; ++i) {
                scramblingFs.mkdirs(new File(parent, String.valueOf(i + 1)));
            }
            Map directories = myStorage.openIndexDirectories();
            Assertions.assertEquals((int)directoryCount, (int)directories.size());
            int previous = 0;
            for (Map.Entry directory : directories.entrySet()) {
                int current = Integer.parseInt(((File)directory.getKey()).getName());
                Assertions.assertTrue((current > previous ? 1 : 0) != 0, (String)("Wanted directory " + current + " to have higher id than previous " + previous));
                previous = current;
            }
        }
    }

    private void createRandomFilesAndFolders(File rootFolder) throws IOException {
        int count = ThreadLocalRandom.current().nextInt(10) + 1;
        for (int i = 0; i < count; ++i) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.createRandomFile(rootFolder);
                continue;
            }
            this.createRandomFolder(rootFolder);
        }
    }

    private Directory createRandomLuceneDir(File rootFolder) throws IOException {
        File folder = this.createRandomFolder(rootFolder);
        Directory directory = directoryFactory.open(folder);
        try (IndexWriter writer = new IndexWriter(directory, IndexWriterConfigs.standard());){
            writer.addDocument((Iterable)PartitionedIndexStorageTest.randomDocument());
            writer.commit();
        }
        return directory;
    }

    private void createRandomFile(File rootFolder) throws IOException {
        File file = new File(rootFolder, RandomStringUtils.randomNumeric((int)5));
        try (StoreFileChannel channel = this.fs.create(file);){
            channel.writeAll(ByteBuffer.allocate(100));
        }
    }

    private File createRandomFolder(File rootFolder) throws IOException {
        File folder = new File(rootFolder, RandomStringUtils.randomNumeric((int)5));
        this.fs.mkdirs(folder);
        return folder;
    }

    private static Document randomDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("field", RandomStringUtils.randomNumeric((int)5), Field.Store.YES));
        return doc;
    }
}

