/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.FailureStorage;
import org.neo4j.kernel.api.impl.index.storage.layout.FolderLayout;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class FailureStorageTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    private IndexFolderLayout indexFolderLayout;

    FailureStorageTest() {
    }

    @BeforeEach
    void before() {
        File rootDirectory = new File("dir");
        this.fs.mkdirs(rootDirectory);
        this.indexFolderLayout = new IndexFolderLayout(rootDirectory);
    }

    @Test
    void shouldReserveFailureFile() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs, (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        File failureFile = storage.failureFile();
        Assertions.assertTrue((boolean)this.fs.fileExists(failureFile));
        Assertions.assertTrue((this.fs.getFileSize(failureFile) > 100L ? 1 : 0) != 0);
    }

    @Test
    void shouldStoreFailure() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs, (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        String failure = String.format("A failure message%nspanning%nmultiple lines.", new Object[0]);
        storage.storeIndexFailure(failure);
        File failureFile = storage.failureFile();
        Assertions.assertTrue((boolean)this.fs.fileExists(failureFile));
        Assertions.assertTrue((this.fs.getFileSize(failureFile) > 100L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)failure, (Object)storage.loadIndexFailure());
    }

    @Test
    void shouldClearFailure() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs, (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        String failure = String.format("A failure message%nspanning%nmultiple lines.", new Object[0]);
        storage.storeIndexFailure(failure);
        File failureFile = storage.failureFile();
        Assertions.assertTrue((boolean)this.fs.fileExists(failureFile));
        Assertions.assertTrue((this.fs.getFileSize(failureFile) > 100L ? 1 : 0) != 0);
        storage.clearForIndex();
        Assertions.assertFalse((boolean)this.fs.fileExists(failureFile));
    }

    @Test
    void shouldAppendFailureIfAlreadyExists() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs, (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        String failure1 = "Once upon a time there was a first failure";
        String failure2 = "Then there was another";
        storage.storeIndexFailure(failure1);
        storage.storeIndexFailure(failure2);
        String allFailures = storage.loadIndexFailure();
        MatcherAssert.assertThat((Object)allFailures, (Matcher)CoreMatchers.containsString((String)failure1));
        MatcherAssert.assertThat((Object)allFailures, (Matcher)CoreMatchers.containsString((String)failure2));
    }
}

