/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.sampler;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

class AggregatingIndexSamplerTest {
    AggregatingIndexSamplerTest() {
    }

    @Test
    void samplePartitionedIndex() {
        List<IndexSampler> samplers = Arrays.asList(AggregatingIndexSamplerTest.createSampler(1L), AggregatingIndexSamplerTest.createSampler(2L));
        AggregatingIndexSampler partitionedSampler = new AggregatingIndexSampler(samplers);
        IndexSample sample = partitionedSampler.sampleIndex();
        Assertions.assertEquals((Object)new IndexSample(3L, 3L, 6L), (Object)sample);
    }

    private static IndexSampler createSampler(long value) {
        return new TestIndexSampler(value);
    }

    private static class TestIndexSampler
    implements IndexSampler {
        private final long value;

        TestIndexSampler(long value) {
            this.value = value;
        }

        public IndexSample sampleIndex() {
            return new IndexSample(this.value, this.value, this.value * 2L);
        }
    }
}

