/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.partition;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class IndexPartitionFactoryTest {
    @Inject
    private TestDirectory testDirectory;
    private Directory directory;

    IndexPartitionFactoryTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.directory = DirectoryFactory.PERSISTENT.open(this.testDirectory.directory());
    }

    @Test
    void createReadOnlyPartition() throws Exception {
        this.prepareIndex();
        try (AbstractIndexPartition indexPartition = new ReadOnlyIndexPartitionFactory().createPartition(this.testDirectory.directory(), this.directory);){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((AbstractIndexPartition)indexPartition).getIndexWriter());
        }
    }

    @Test
    void createWritablePartition() throws Exception {
        try (AbstractIndexPartition indexPartition = new WritableIndexPartitionFactory(IndexWriterConfigs::standard).createPartition(this.testDirectory.directory(), this.directory);
             IndexWriter indexWriter = indexPartition.getIndexWriter();){
            indexWriter.addDocument((Iterable)new Document());
            indexWriter.commit();
            indexPartition.maybeRefreshBlocking();
            try (PartitionSearcher searcher = indexPartition.acquireSearcher();){
                Assertions.assertEquals((int)1, (int)searcher.getIndexSearcher().getIndexReader().numDocs(), (String)"We should be able to see newly added document ");
            }
        }
    }

    private void prepareIndex() throws IOException {
        File location = this.testDirectory.directory();
        AbstractIndexPartition ignored = new WritableIndexPartitionFactory(IndexWriterConfigs::standard).createPartition(location, DirectoryFactory.PERSISTENT.open(location));
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
    }
}

