/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.api.impl.index.IndexReaderStub;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

final class DocValuesCollectorTest {
    DocValuesCollectorTest() {
    }

    @Test
    void shouldStartWithEmptyMatchingDocs() {
        DocValuesCollector collector = new DocValuesCollector();
        Assertions.assertEquals(Collections.emptyList(), (Object)collector.getMatchingDocs());
    }

    @Test
    void shouldCollectAllHitsPerSegment() throws Exception {
        DocValuesCollector collector = new DocValuesCollector();
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(3);
        collector.collect(5);
        collector.collect(9);
        Assertions.assertEquals((int)4, (int)collector.getTotalHits());
        List allMatchingDocs = collector.getMatchingDocs();
        Assertions.assertEquals((int)1, (int)allMatchingDocs.size());
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)allMatchingDocs.get(0);
        Assertions.assertSame((Object)readerStub.getContext(), (Object)matchingDocs.context);
        Assertions.assertEquals((int)4, (int)matchingDocs.totalHits);
        DocIdSetIterator idIterator = matchingDocs.docIdSet.iterator();
        Assertions.assertEquals((int)1, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)3, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)5, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)9, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)idIterator.nextDoc());
    }

    @Test
    void shouldCollectOneMatchingDocsPerSegment() throws Exception {
        DocValuesCollector collector = new DocValuesCollector();
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(3);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(5);
        collector.collect(9);
        Assertions.assertEquals((int)4, (int)collector.getTotalHits());
        List allMatchingDocs = collector.getMatchingDocs();
        Assertions.assertEquals((int)2, (int)allMatchingDocs.size());
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)allMatchingDocs.get(0);
        Assertions.assertSame((Object)readerStub.getContext(), (Object)matchingDocs.context);
        Assertions.assertEquals((int)2, (int)matchingDocs.totalHits);
        DocIdSetIterator idIterator = matchingDocs.docIdSet.iterator();
        Assertions.assertEquals((int)1, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)3, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)idIterator.nextDoc());
        matchingDocs = (DocValuesCollector.MatchingDocs)allMatchingDocs.get(1);
        Assertions.assertSame((Object)readerStub.getContext(), (Object)matchingDocs.context);
        Assertions.assertEquals((int)2, (int)matchingDocs.totalHits);
        idIterator = matchingDocs.docIdSet.iterator();
        Assertions.assertEquals((int)5, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)9, (int)idIterator.nextDoc());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)idIterator.nextDoc());
    }

    @Test
    void shouldNotSaveScoresWhenNotRequired() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        Assertions.assertNull((Object)matchingDocs.scores);
    }

    @Test
    void shouldSaveScoresWhenRequired() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(13.42f));
        collector.collect(1);
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        Assertions.assertArrayEquals((float[])new float[]{13.42f}, (float[])matchingDocs.scores, (float)0.001f);
    }

    @Test
    void shouldSaveScoresInADenseArray() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(1.0f));
        collector.collect(1);
        collector.setScorer(DocValuesCollectorTest.constantScorer(41.0f));
        collector.collect(41);
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 41.0f}, (float[])matchingDocs.scores, (float)0.001f);
    }

    @Test
    void shouldDynamicallyResizeScoresArray() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(1.0f));
        for (int i = 0; i < 42; ++i) {
            collector.collect(i);
        }
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        float[] scores = new float[42];
        Arrays.fill(scores, 1.0f);
        Assertions.assertArrayEquals((float[])scores, (float[])matchingDocs.scores, (float)0.001f);
    }

    @Test
    void shouldReturnIndexHitsInIndexOrderWhenNoSortIsGiven() throws Exception {
        DocValuesCollector collector = new DocValuesCollector();
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        IndexHits indexHits = collector.getIndexHits(null);
        Assertions.assertEquals((int)2, (int)indexHits.size());
        Assertions.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((Object)"2", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    void shouldReturnIndexHitsOrderedByRelevance() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(1.0f));
        collector.collect(1);
        collector.setScorer(DocValuesCollectorTest.constantScorer(2.0f));
        collector.collect(2);
        IndexHits indexHits = collector.getIndexHits(Sort.RELEVANCE);
        Assertions.assertEquals((int)2, (int)indexHits.size());
        Assertions.assertEquals((Object)"2", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((float)2.0f, (float)indexHits.currentScore(), (float)0.001f);
        Assertions.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((float)1.0f, (float)indexHits.currentScore(), (float)0.001f);
        Assertions.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    void shouldReturnIndexHitsInGivenSortOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(43);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(3);
        collector.collect(37);
        collector.collect(42);
        Sort byIdDescending = new Sort(new SortField("id", SortField.Type.LONG, true));
        IndexHits indexHits = collector.getIndexHits(byIdDescending);
        Assertions.assertEquals((int)4, (int)indexHits.size());
        Assertions.assertEquals((Object)"42", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((Object)"37", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((Object)"3", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    void shouldSilentlyMergeAllSegments() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(2);
        IndexHits indexHits = collector.getIndexHits(null);
        Assertions.assertEquals((int)2, (int)indexHits.size());
        Assertions.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertEquals((Object)"2", (Object)((Document)indexHits.next()).get("id"));
        Assertions.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    void shouldReturnEmptyIteratorWhenNoHits() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        IndexHits indexHits = collector.getIndexHits(null);
        Assertions.assertEquals((int)0, (int)indexHits.size());
        Assertions.assertEquals((float)Float.NaN, (float)indexHits.currentScore(), (float)0.001f);
        Assertions.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    void shouldReadDocValuesInIndexOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator("id");
        Assertions.assertEquals((int)2, (int)valuesIterator.remaining());
        Assertions.assertEquals((long)1L, (long)valuesIterator.next());
        Assertions.assertEquals((long)2L, (long)valuesIterator.next());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldSilentlyMergeSegmentsWhenReadingDocValues() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(2);
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator("id");
        Assertions.assertEquals((int)2, (int)valuesIterator.remaining());
        Assertions.assertEquals((long)1L, (long)valuesIterator.next());
        Assertions.assertEquals((long)2L, (long)valuesIterator.next());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldReturnEmptyIteratorWhenNoDocValues() {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator("id");
        Assertions.assertEquals((int)0, (int)valuesIterator.remaining());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldReturnDocValuesInIndexOrderWhenNoSortIsGiven() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", null);
        Assertions.assertEquals((long)1L, (long)valuesIterator.next());
        Assertions.assertEquals((long)2L, (long)valuesIterator.next());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldReturnDocValuesInRelevanceOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(1.0f));
        collector.collect(1);
        collector.setScorer(DocValuesCollectorTest.constantScorer(2.0f));
        collector.collect(2);
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", Sort.RELEVANCE);
        Assertions.assertEquals((long)2L, (long)valuesIterator.next());
        Assertions.assertEquals((long)1L, (long)valuesIterator.next());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldReturnDocValuesInGivenOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        Sort byIdDescending = new Sort(new SortField("id", SortField.Type.LONG, true));
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", byIdDescending);
        Assertions.assertEquals((long)2L, (long)valuesIterator.next());
        Assertions.assertEquals((long)1L, (long)valuesIterator.next());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldSilentlyMergeSegmentsWhenReturnDocValuesInOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(1.0f));
        collector.collect(1);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(DocValuesCollectorTest.constantScorer(2.0f));
        collector.collect(2);
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", Sort.RELEVANCE);
        Assertions.assertEquals((long)2L, (long)valuesIterator.next());
        Assertions.assertEquals((long)1L, (long)valuesIterator.next());
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    void shouldReturnEmptyIteratorWhenNoDocValuesInOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = DocValuesCollectorTest.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", Sort.RELEVANCE);
        Assertions.assertFalse((boolean)valuesIterator.hasNext());
    }

    private static IndexReaderStub indexReaderWithMaxDocs(int maxDocs) {
        NumericDocValues identityValues = new NumericDocValues(){

            public long get(int docID) {
                return docID;
            }
        };
        IndexReaderStub stub = new IndexReaderStub(identityValues);
        stub.setElements(new String[maxDocs]);
        return stub;
    }

    private static Scorer constantScorer(float score) {
        return new ConstantScoreScorer(null, score, (DocIdSetIterator)null);
    }
}

