/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.backup;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.backup.LuceneIndexSnapshots;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
public class ReadOnlyIndexSnapshotFileIteratorTest {
    @Inject
    private TestDirectory testDir;
    File indexDir;
    protected Directory dir;

    @BeforeEach
    void setUp() throws IOException {
        this.indexDir = this.testDir.databaseDir();
        this.dir = DirectoryFactory.PERSISTENT.open(this.indexDir);
    }

    @AfterEach
    public void tearDown() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Directory[]{this.dir});
    }

    @Test
    void shouldReturnRealSnapshotIfIndexAllowsIt() throws IOException {
        this.prepareIndex();
        Set<String> files = ReadOnlyIndexSnapshotFileIteratorTest.listDir(this.dir);
        Assertions.assertFalse((boolean)files.isEmpty());
        try (ResourceIterator<File> snapshot = this.makeSnapshot();){
            Set snapshotFiles = snapshot.stream().map(File::getName).collect(Collectors.toSet());
            Assertions.assertEquals(files, snapshotFiles);
        }
    }

    @Test
    void shouldReturnEmptyIteratorWhenNoCommitsHaveBeenMade() throws IOException {
        try (ResourceIterator<File> snapshot = this.makeSnapshot();){
            Assertions.assertFalse((boolean)snapshot.hasNext());
        }
    }

    private void prepareIndex() throws IOException {
        try (IndexWriter writer = new IndexWriter(this.dir, IndexWriterConfigs.standard());){
            ReadOnlyIndexSnapshotFileIteratorTest.insertRandomDocuments(writer);
        }
    }

    protected ResourceIterator<File> makeSnapshot() throws IOException {
        return LuceneIndexSnapshots.forIndex((File)this.indexDir, (Directory)this.dir);
    }

    private static void insertRandomDocuments(IndexWriter writer) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("a", "b", Field.Store.YES));
        doc.add((IndexableField)new StringField("c", "d", Field.Store.NO));
        writer.addDocument((Iterable)doc);
        writer.commit();
    }

    private static Set<String> listDir(Directory dir) throws IOException {
        String[] files = dir.listAll();
        return Stream.of(files).filter(file -> !"write.lock".equals(file)).collect(Collectors.toSet());
    }
}

