/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneSchemaIndexPopulationIT {
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0});
    @Inject
    private TestDirectory testDir;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;

    LuceneSchemaIndexPopulationIT() {
    }

    @BeforeEach
    void before() {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "10");
    }

    @AfterEach
    void after() {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
    }

    @ParameterizedTest
    @ValueSource(ints={7, 11, 14, 20, 35, 58})
    void partitionedIndexPopulation(int affectedNodes) throws Exception {
        File rootFolder = new File(this.testDir.directory("partitionIndex" + affectedNodes), "uniqueIndex" + affectedNodes);
        try (SchemaIndex uniqueIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.descriptor, (Config)Config.defaults()).withFileSystem((FileSystemAbstraction)this.fileSystem)).withIndexRootFolder(rootFolder)).build();){
            uniqueIndex.open();
            Assertions.assertEquals((long)0L, (long)uniqueIndex.allDocumentsReader().maxCount());
            Assertions.assertFalse((boolean)uniqueIndex.exists());
            try (LuceneIndexAccessor indexAccessor = new LuceneIndexAccessor(uniqueIndex, this.descriptor);){
                this.generateUpdates(indexAccessor, affectedNodes);
                indexAccessor.force(IOLimiter.UNLIMITED);
                Assertions.assertTrue((boolean)uniqueIndex.isOnline());
                try (IndexReader indexReader = indexAccessor.newReader();){
                    long[] nodes = PrimitiveLongCollections.asArray((LongIterator)indexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)}));
                    Assertions.assertEquals((int)affectedNodes, (int)nodes.length);
                    IndexSampler indexSampler = indexReader.createSampler();
                    IndexSample sample = indexSampler.sampleIndex();
                    Assertions.assertEquals((long)affectedNodes, (long)sample.indexSize());
                    Assertions.assertEquals((long)affectedNodes, (long)sample.uniqueValues());
                    Assertions.assertEquals((long)affectedNodes, (long)sample.sampleSize());
                }
            }
        }
    }

    private void generateUpdates(LuceneIndexAccessor indexAccessor, int nodesToUpdate) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = indexAccessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (int nodeId = 0; nodeId < nodesToUpdate; ++nodeId) {
                updater.process(this.add(nodeId, nodeId));
            }
        }
    }

    private IndexEntryUpdate<?> add(long nodeId, Object value) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{Values.of((Object)value)});
    }
}

