/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.WritableAbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.storageengine.api.schema.AbstractIndexReader;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class DatabaseIndexIntegrationTest {
    private static final int THREAD_NUMBER = 5;
    private static ExecutorService workers;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    private final CountDownLatch raceSignal = new CountDownLatch(1);
    private SyncNotifierDirectoryFactory directoryFactory;
    private WritableTestDatabaseIndex luceneIndex;

    DatabaseIndexIntegrationTest() {
    }

    @BeforeAll
    static void initExecutors() {
        workers = Executors.newFixedThreadPool(5);
    }

    @AfterAll
    static void shutDownExecutor() {
        workers.shutdownNow();
    }

    @BeforeEach
    void setUp() throws IOException {
        this.directoryFactory = new SyncNotifierDirectoryFactory(this.raceSignal);
        this.luceneIndex = this.createTestLuceneIndex(this.directoryFactory, this.testDirectory.directory());
    }

    @AfterEach
    void tearDown() {
        this.directoryFactory.close();
    }

    @RepeatedTest(value=2)
    void testSaveCallCommitAndCloseFromMultipleThreads() {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(60L), () -> {
            this.generateInitialData();
            Supplier<Runnable> closeTaskSupplier = () -> this.createConcurrentCloseTask(this.raceSignal);
            List<Future<?>> closeFutures = this.submitTasks(closeTaskSupplier);
            for (Future<?> closeFuture : closeFutures) {
                closeFuture.get();
            }
            Assertions.assertFalse((boolean)this.luceneIndex.isOpen());
        });
    }

    @RepeatedTest(value=2)
    void saveCallCloseAndDropFromMultipleThreads() {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(60L), () -> {
            this.generateInitialData();
            Supplier<Runnable> dropTaskSupplier = () -> this.createConcurrentDropTask(this.raceSignal);
            List<Future<?>> futures = this.submitTasks(dropTaskSupplier);
            for (Future<?> future : futures) {
                future.get();
            }
            Assertions.assertFalse((boolean)this.luceneIndex.isOpen());
        });
    }

    private WritableTestDatabaseIndex createTestLuceneIndex(DirectoryFactory dirFactory, File folder) throws IOException {
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(dirFactory, (FileSystemAbstraction)this.fileSystem, folder);
        WritableTestDatabaseIndex index = new WritableTestDatabaseIndex(indexStorage);
        index.create();
        index.open();
        return index;
    }

    private List<Future<?>> submitTasks(Supplier<Runnable> taskSupplier) {
        ArrayList futures = new ArrayList(5);
        futures.add(workers.submit(this.createMainCloseTask()));
        for (int i = 0; i < 4; ++i) {
            futures.add(workers.submit(taskSupplier.get()));
        }
        return futures;
    }

    private void generateInitialData() throws IOException {
        IndexWriter indexWriter = this.firstPartitionWriter();
        for (int i = 0; i < 10; ++i) {
            indexWriter.addDocument((Iterable)DatabaseIndexIntegrationTest.createTestDocument());
        }
    }

    private Runnable createConcurrentDropTask(CountDownLatch dropRaceSignal) {
        return () -> {
            try {
                dropRaceSignal.await();
                Thread.yield();
                this.luceneIndex.drop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Runnable createConcurrentCloseTask(CountDownLatch closeRaceSignal) {
        return () -> {
            try {
                closeRaceSignal.await();
                Thread.yield();
                this.luceneIndex.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Runnable createMainCloseTask() {
        return () -> {
            try {
                this.luceneIndex.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static Document createTestDocument() {
        Document document = new Document();
        document.add((IndexableField)new TextField("text", "textValue", Field.Store.YES));
        document.add((IndexableField)new LongField("long", 1L, Field.Store.YES));
        return document;
    }

    private IndexWriter firstPartitionWriter() {
        List partitions = this.luceneIndex.getPartitions();
        Assertions.assertEquals((int)1, (int)partitions.size());
        AbstractIndexPartition partition = (AbstractIndexPartition)partitions.get(0);
        return partition.getIndexWriter();
    }

    private static class SyncNotifierDirectoryFactory
    implements DirectoryFactory {
        final CountDownLatch signal;

        SyncNotifierDirectoryFactory(CountDownLatch signal) {
            this.signal = signal;
        }

        public Directory open(File dir, CountDownLatch signal) throws IOException {
            Directory directory = this.open(dir);
            return new SyncNotifierDirectory(directory, signal);
        }

        public Directory open(File dir) throws IOException {
            dir.mkdirs();
            FSDirectory fsDir = FSDirectory.open((Path)dir.toPath());
            return new SyncNotifierDirectory((Directory)fsDir, this.signal);
        }

        public void close() {
        }

        private static class SyncNotifierDirectory
        extends Directory {
            private final Directory delegate;
            private final CountDownLatch signal;

            SyncNotifierDirectory(Directory delegate, CountDownLatch signal) {
                this.delegate = delegate;
                this.signal = signal;
            }

            public String[] listAll() throws IOException {
                return this.delegate.listAll();
            }

            public void deleteFile(String name) throws IOException {
                this.delegate.deleteFile(name);
            }

            public long fileLength(String name) throws IOException {
                return this.delegate.fileLength(name);
            }

            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                return this.delegate.createOutput(name, context);
            }

            public void sync(Collection<String> names) throws IOException {
                if (names.stream().noneMatch(name -> name.startsWith("pending_segments"))) {
                    try {
                        this.signal.countDown();
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.delegate.sync(names);
            }

            public void renameFile(String source, String dest) throws IOException {
                this.delegate.renameFile(source, dest);
            }

            public IndexInput openInput(String name, IOContext context) throws IOException {
                return this.delegate.openInput(name, context);
            }

            public Lock obtainLock(String name) throws IOException {
                return this.delegate.obtainLock(name);
            }

            public void close() throws IOException {
                this.delegate.close();
            }
        }
    }

    private static class TestLuceneIndex
    extends AbstractLuceneIndex<AbstractIndexReader> {
        TestLuceneIndex(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory) {
            super(indexStorage, partitionFactory, null);
        }

        protected AbstractIndexReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
            return null;
        }

        protected AbstractIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
            return null;
        }
    }

    private static class WritableTestDatabaseIndex
    extends WritableAbstractDatabaseIndex<TestLuceneIndex, AbstractIndexReader> {
        WritableTestDatabaseIndex(PartitionedIndexStorage indexStorage) {
            super((AbstractLuceneIndex)new TestLuceneIndex(indexStorage, (IndexPartitionFactory)new WritableIndexPartitionFactory(IndexWriterConfigs::standard)));
        }
    }
}

