/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.index.impl.lucene.explicit.CloseTrackingIndexReader;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.WritableIndexReference;

class WritableIndexReferenceTest {
    private IndexIdentifier identifier = (IndexIdentifier)Mockito.mock(IndexIdentifier.class);
    private IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
    private IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
    private CloseTrackingIndexReader reader = new CloseTrackingIndexReader();
    private WritableIndexReference indexReference = new WritableIndexReference(this.identifier, this.searcher, this.indexWriter);

    WritableIndexReferenceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.searcher.getIndexReader()).thenReturn((Object)this.reader);
    }

    @Test
    void useProvidedWriterAsIndexWriter() {
        Assertions.assertSame((Object)this.indexWriter, (Object)this.indexReference.getWriter());
    }

    @Test
    void stalingWritableIndex() {
        Assertions.assertFalse((boolean)this.indexReference.checkAndClearStale(), (String)"Index is not stale by default.");
        this.indexReference.setStale();
        Assertions.assertTrue((boolean)this.indexReference.checkAndClearStale(), (String)"We should be able to reset stale index state.");
        Assertions.assertFalse((boolean)this.indexReference.checkAndClearStale(), (String)"Index is not stale anymore.");
    }

    @Test
    void disposeWritableIndex() throws Exception {
        this.indexReference.dispose();
        Assertions.assertTrue((boolean)this.reader.isClosed(), (String)"Reader should be closed.");
        Assertions.assertTrue((boolean)this.indexReference.isWriterClosed(), (String)"Reader should be closed.");
    }
}

