/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.index.impl.lucene.explicit.CloseTrackingIndexReader;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.ReadOnlyIndexReference;

class ReadOnlyIndexReferenceTest {
    private IndexIdentifier identifier = (IndexIdentifier)Mockito.mock(IndexIdentifier.class);
    private IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
    private CloseTrackingIndexReader reader = new CloseTrackingIndexReader();
    private ReadOnlyIndexReference indexReference = new ReadOnlyIndexReference(this.identifier, this.searcher);

    ReadOnlyIndexReferenceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.searcher.getIndexReader()).thenReturn((Object)this.reader);
    }

    @Test
    void obtainingWriterIsUnsupported() {
        UnsupportedOperationException uoe = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.indexReference.getWriter());
        Assertions.assertEquals((Object)uoe.getMessage(), (Object)"Read only indexes do not have index writers.");
    }

    @Test
    void markAsStaleIsUnsupported() {
        UnsupportedOperationException uoe = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.indexReference.setStale());
        Assertions.assertEquals((Object)uoe.getMessage(), (Object)"Read only indexes can't be marked as stale.");
    }

    @Test
    void checkAndClearStaleAlwaysFalse() {
        Assertions.assertFalse((boolean)this.indexReference.checkAndClearStale());
    }

    @Test
    void disposeClosingSearcherAndMarkAsClosed() throws IOException {
        this.indexReference.dispose();
        Assertions.assertTrue((boolean)this.reader.isClosed());
        Assertions.assertTrue((boolean)this.indexReference.isClosed());
    }

    @Test
    void detachIndexReferenceWhenSomeReferencesExist() throws IOException {
        this.indexReference.incRef();
        this.indexReference.detachOrClose();
        Assertions.assertTrue((boolean)this.indexReference.isDetached(), (String)"Should leave index in detached state.");
    }

    @Test
    void closeIndexReferenceWhenNoReferenceExist() throws IOException {
        this.indexReference.detachOrClose();
        Assertions.assertFalse((boolean)this.indexReference.isDetached(), (String)"Should leave index in closed state.");
        Assertions.assertTrue((boolean)this.reader.isClosed());
        Assertions.assertTrue((boolean)this.indexReference.isClosed());
    }

    @Test
    void doNotCloseInstanceWhenSomeReferenceExist() {
        this.indexReference.incRef();
        Assertions.assertFalse((boolean)this.indexReference.close());
        Assertions.assertFalse((boolean)this.indexReference.isClosed());
    }

    @Test
    void closeDetachedIndexReferencedOnlyOnce() throws IOException {
        this.indexReference.incRef();
        this.indexReference.detachOrClose();
        Assertions.assertTrue((boolean)this.indexReference.isDetached(), (String)"Should leave index in detached state.");
        Assertions.assertTrue((boolean)this.indexReference.close());
        Assertions.assertTrue((boolean)this.reader.isClosed());
        Assertions.assertTrue((boolean)this.indexReference.isClosed());
    }

    @Test
    void doNotCloseDetachedIndexReferencedMoreThenOnce() throws IOException {
        this.indexReference.incRef();
        this.indexReference.incRef();
        this.indexReference.detachOrClose();
        Assertions.assertTrue((boolean)this.indexReference.isDetached(), (String)"Should leave index in detached state.");
        Assertions.assertFalse((boolean)this.indexReference.close());
    }

    @Test
    void doNotCloseReferencedIndex() {
        this.indexReference.incRef();
        Assertions.assertFalse((boolean)this.indexReference.close());
        Assertions.assertFalse((boolean)this.indexReference.isClosed());
    }

    @Test
    void closeNotReferencedIndex() {
        Assertions.assertTrue((boolean)this.indexReference.close());
    }
}

