/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexReference;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.index.impl.lucene.explicit.ReadOnlyIndexReference;
import org.neo4j.index.impl.lucene.explicit.WritableIndexReference;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneDataSourceTest {
    private final LifeRule life = new LifeRule(true);
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.life).around((TestRule)this.expectedException);
    private IndexConfigStore indexStore;
    private LuceneDataSource dataSource;

    @Before
    public void setUp() {
        this.indexStore = new IndexConfigStore(this.directory.databaseLayout(), this.fileSystemRule.get());
        this.addIndex("foo");
    }

    @Test
    public void doNotTryToCommitWritersOnForceInReadOnlyMode() throws Exception {
        IndexIdentifier indexIdentifier = LuceneDataSourceTest.identifier("foo");
        this.prepareIndexesByIdentifiers(indexIdentifier);
        this.stopDataSource();
        Config readOnlyConfig = Config.defaults(LuceneDataSourceTest.readOnlyConfig());
        LuceneDataSource readOnlyDataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(readOnlyConfig));
        Assert.assertNotNull((Object)readOnlyDataSource.getIndexSearcher(indexIdentifier));
        readOnlyDataSource.force();
    }

    @Test
    public void notAllowIndexDeletionInReadOnlyMode() throws Exception {
        IndexIdentifier indexIdentifier = LuceneDataSourceTest.identifier("foo");
        this.prepareIndexesByIdentifiers(indexIdentifier);
        this.stopDataSource();
        Config readOnlyConfig = Config.defaults(LuceneDataSourceTest.readOnlyConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(readOnlyConfig, OperationalMode.single));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Index deletion in read only mode is not supported.");
        this.dataSource.deleteIndex(indexIdentifier, false);
    }

    @Test
    public void useReadOnlyIndexSearcherInReadOnlyModeForSingleInstance() throws Exception {
        IndexIdentifier indexIdentifier = LuceneDataSourceTest.identifier("foo");
        this.prepareIndexesByIdentifiers(indexIdentifier);
        this.stopDataSource();
        Config readOnlyConfig = Config.defaults(LuceneDataSourceTest.readOnlyConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(readOnlyConfig, OperationalMode.single));
        IndexReference indexSearcher = this.dataSource.getIndexSearcher(indexIdentifier);
        Assert.assertTrue((String)"Read only index reference should be used in read only mode.", (boolean)ReadOnlyIndexReference.class.isInstance(indexSearcher));
    }

    @Test
    public void useWritableIndexSearcherInReadOnlyModeForNonSingleInstance() throws Exception {
        IndexIdentifier indexIdentifier = LuceneDataSourceTest.identifier("foo");
        this.prepareIndexesByIdentifiers(indexIdentifier);
        this.stopDataSource();
        Config readOnlyConfig = Config.defaults(LuceneDataSourceTest.readOnlyConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(readOnlyConfig, OperationalMode.ha));
        IndexReference indexSearcher = this.dataSource.getIndexSearcher(indexIdentifier);
        Assert.assertTrue((String)"Writable index reference should be used in read only mode in ha mode.", (boolean)WritableIndexReference.class.isInstance(indexSearcher));
    }

    @Test
    public void refreshReadOnlyIndexSearcherInReadOnlyMode() throws Exception {
        IndexIdentifier indexIdentifier = LuceneDataSourceTest.identifier("foo");
        this.prepareIndexesByIdentifiers(indexIdentifier);
        this.stopDataSource();
        Config readOnlyConfig = Config.defaults(LuceneDataSourceTest.readOnlyConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(readOnlyConfig));
        IndexReference indexSearcher = this.dataSource.getIndexSearcher(indexIdentifier);
        IndexReference indexSearcher2 = this.dataSource.getIndexSearcher(indexIdentifier);
        IndexReference indexSearcher3 = this.dataSource.getIndexSearcher(indexIdentifier);
        IndexReference indexSearcher4 = this.dataSource.getIndexSearcher(indexIdentifier);
        Assert.assertSame((String)"Refreshed read only searcher should be the same.", (Object)indexSearcher, (Object)indexSearcher2);
        Assert.assertSame((String)"Refreshed read only searcher should be the same.", (Object)indexSearcher2, (Object)indexSearcher3);
        Assert.assertSame((String)"Refreshed read only searcher should be the same.", (Object)indexSearcher3, (Object)indexSearcher4);
    }

    @Test
    public void testShouldReturnIndexWriterFromLRUCache() throws Throwable {
        Config config = Config.defaults();
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        IndexIdentifier identifier = LuceneDataSourceTest.identifier("foo");
        IndexWriter writer = this.dataSource.getIndexSearcher(identifier).getWriter();
        Assert.assertSame((Object)writer, (Object)this.dataSource.getIndexSearcher(identifier).getWriter());
    }

    @Test
    public void testShouldReturnIndexSearcherFromLRUCache() throws Throwable {
        Config config = Config.defaults();
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        IndexIdentifier identifier = LuceneDataSourceTest.identifier("foo");
        IndexReference searcher = this.dataSource.getIndexSearcher(identifier);
        Assert.assertSame((Object)searcher, (Object)this.dataSource.getIndexSearcher(identifier));
        searcher.close();
    }

    @Test
    public void testClosesOldestIndexWriterWhenCacheSizeIsExceeded() throws Throwable {
        this.addIndex("bar");
        this.addIndex("baz");
        Config config = Config.defaults(LuceneDataSourceTest.cacheSizeConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        IndexIdentifier fooIdentifier = LuceneDataSourceTest.identifier("foo");
        IndexIdentifier barIdentifier = LuceneDataSourceTest.identifier("bar");
        IndexIdentifier bazIdentifier = LuceneDataSourceTest.identifier("baz");
        IndexWriter fooIndexWriter = this.dataSource.getIndexSearcher(fooIdentifier).getWriter();
        this.dataSource.getIndexSearcher(barIdentifier);
        Assert.assertTrue((boolean)fooIndexWriter.isOpen());
        this.dataSource.getIndexSearcher(bazIdentifier);
        Assert.assertFalse((boolean)fooIndexWriter.isOpen());
    }

    @Test
    public void testClosesOldestIndexSearcherWhenCacheSizeIsExceeded() throws Throwable {
        this.addIndex("bar");
        this.addIndex("baz");
        Config config = Config.defaults(LuceneDataSourceTest.cacheSizeConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        IndexIdentifier fooIdentifier = LuceneDataSourceTest.identifier("foo");
        IndexIdentifier barIdentifier = LuceneDataSourceTest.identifier("bar");
        IndexIdentifier bazIdentifier = LuceneDataSourceTest.identifier("baz");
        IndexReference fooSearcher = this.dataSource.getIndexSearcher(fooIdentifier);
        IndexReference barSearcher = this.dataSource.getIndexSearcher(barIdentifier);
        Assert.assertFalse((boolean)fooSearcher.isClosed());
        IndexReference bazSearcher = this.dataSource.getIndexSearcher(bazIdentifier);
        Assert.assertTrue((boolean)fooSearcher.isClosed());
        barSearcher.close();
        bazSearcher.close();
    }

    @Test
    public void testRecreatesSearcherWhenRequestedAgain() throws Throwable {
        this.addIndex("bar");
        this.addIndex("baz");
        Config config = Config.defaults(LuceneDataSourceTest.cacheSizeConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        IndexIdentifier fooIdentifier = LuceneDataSourceTest.identifier("foo");
        IndexIdentifier barIdentifier = LuceneDataSourceTest.identifier("bar");
        IndexIdentifier bazIdentifier = LuceneDataSourceTest.identifier("baz");
        IndexReference oldFooSearcher = this.dataSource.getIndexSearcher(fooIdentifier);
        IndexReference barSearcher = this.dataSource.getIndexSearcher(barIdentifier);
        IndexReference bazSearcher = this.dataSource.getIndexSearcher(bazIdentifier);
        IndexReference newFooSearcher = this.dataSource.getIndexSearcher(bazIdentifier);
        Assert.assertNotSame((Object)oldFooSearcher, (Object)newFooSearcher);
        Assert.assertFalse((boolean)newFooSearcher.isClosed());
        oldFooSearcher.close();
        barSearcher.close();
        bazSearcher.close();
        newFooSearcher.close();
    }

    @Test
    public void testRecreatesWriterWhenRequestedAgainAfterCacheEviction() throws Throwable {
        this.addIndex("bar");
        this.addIndex("baz");
        Config config = Config.defaults(LuceneDataSourceTest.cacheSizeConfig());
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        IndexIdentifier fooIdentifier = LuceneDataSourceTest.identifier("foo");
        IndexIdentifier barIdentifier = LuceneDataSourceTest.identifier("bar");
        IndexIdentifier bazIdentifier = LuceneDataSourceTest.identifier("baz");
        IndexWriter oldFooIndexWriter = this.dataSource.getIndexSearcher(fooIdentifier).getWriter();
        this.dataSource.getIndexSearcher(barIdentifier);
        this.dataSource.getIndexSearcher(bazIdentifier);
        IndexWriter newFooIndexWriter = this.dataSource.getIndexSearcher(fooIdentifier).getWriter();
        Assert.assertNotSame((Object)oldFooIndexWriter, (Object)newFooIndexWriter);
        Assert.assertTrue((boolean)newFooIndexWriter.isOpen());
    }

    private void stopDataSource() throws IOException {
        this.dataSource.shutdown();
    }

    private void prepareIndexesByIdentifiers(IndexIdentifier indexIdentifier) throws Exception {
        Config config = Config.defaults();
        this.dataSource = (LuceneDataSource)this.life.add((Lifecycle)this.getLuceneDataSource(config));
        this.dataSource.getIndexSearcher(indexIdentifier);
        this.dataSource.force();
    }

    private static Map<String, String> readOnlyConfig() {
        return MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"});
    }

    private static Map<String, String> cacheSizeConfig() {
        return MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.lucene_searcher_cache_size.name(), "2"});
    }

    private void addIndex(String name) {
        this.indexStore.set(Node.class, name, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
    }

    private static IndexIdentifier identifier(String name) {
        return new IndexIdentifier(IndexEntityType.Node, name);
    }

    private LuceneDataSource getLuceneDataSource(Config config) {
        return this.getLuceneDataSource(config, OperationalMode.unknown);
    }

    private LuceneDataSource getLuceneDataSource(Config config, OperationalMode operationalMode) {
        return new LuceneDataSource(this.directory.databaseLayout(), config, this.indexStore, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), operationalMode);
    }
}

