/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.LuceneCommandApplier;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.index.impl.lucene.explicit.LuceneIndexImplementation;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={EphemeralFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneCommandApplierTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;

    LuceneCommandApplierTest() {
    }

    @Test
    void shouldHandleMultipleIdSpaces() throws Exception {
        String indexName = "name";
        String key = "key";
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        IndexConfigStore configStore = new IndexConfigStore(databaseLayout, (FileSystemAbstraction)this.fs);
        configStore.set(Node.class, indexName, LuceneIndexImplementation.EXACT_CONFIG);
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            Config dataSourceConfig = Config.defaults((Setting)LuceneDataSource.Configuration.ephemeral, (String)"true");
            LuceneDataSource originalDataSource = new LuceneDataSource(databaseLayout, dataSourceConfig, configStore, (FileSystemAbstraction)this.fs, OperationalMode.single);
            LuceneDataSource dataSource = (LuceneDataSource)lifespan.add((Lifecycle)Mockito.spy((Object)originalDataSource));
            try (LuceneCommandApplier applier = new LuceneCommandApplier(dataSource, false);){
                IndexDefineCommand definitions = LuceneCommandApplierTest.definitions((MutableObjectIntMap<String>)ObjectIntHashMap.newWithKeysValues((Object)indexName, (int)0), (MutableObjectIntMap<String>)ObjectIntHashMap.newWithKeysValues((Object)key, (int)0));
                applier.visitIndexDefineCommand(definitions);
                applier.visitIndexAddNodeCommand(LuceneCommandApplierTest.addNodeToIndex(definitions, indexName, 0L));
                definitions = LuceneCommandApplierTest.definitions((MutableObjectIntMap<String>)ObjectIntHashMap.newWithKeysValues((Object)indexName, (int)1), (MutableObjectIntMap<String>)ObjectIntHashMap.newWithKeysValues((Object)key, (int)0));
                applier.visitIndexDefineCommand(definitions);
                applier.visitIndexAddNodeCommand(LuceneCommandApplierTest.addNodeToIndex(definitions, indexName, 1L));
            }
            ((LuceneDataSource)Mockito.verify((Object)dataSource, (VerificationMode)Mockito.times((int)1))).getIndexSearcher((IndexIdentifier)ArgumentMatchers.any(IndexIdentifier.class));
        }
    }

    private static IndexCommand.AddNodeCommand addNodeToIndex(IndexDefineCommand definitions, String indexName, long nodeId) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), nodeId, 0, (Object)"some value");
        return command;
    }

    private static IndexDefineCommand definitions(MutableObjectIntMap<String> names, MutableObjectIntMap<String> keys) {
        IndexDefineCommand definitions = new IndexDefineCommand();
        definitions.init(names, keys);
        return definitions;
    }
}

