/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.explicit.LuceneBatchInserterIndexProviderNewImpl;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class LuceneBatchInserterIndexProviderNewImplTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;

    LuceneBatchInserterIndexProviderNewImplTest() {
    }

    @Test
    void createBatchIndexFromAnyIndexStoreProvider() throws Exception {
        LuceneBatchInserterIndexProviderNewImplTest.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir()));
        LuceneBatchInserterIndexProviderNewImplTest.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)this.fileSystem));
        LuceneBatchInserterIndexProviderNewImplTest.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), LuceneBatchInserterIndexProviderNewImplTest.getConfig(new String[0])));
        LuceneBatchInserterIndexProviderNewImplTest.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), LuceneBatchInserterIndexProviderNewImplTest.getConfigWithProvider(), LuceneBatchInserterIndexProviderNewImplTest.getExtensions()));
        LuceneBatchInserterIndexProviderNewImplTest.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)this.fileSystem, LuceneBatchInserterIndexProviderNewImplTest.getConfig(new String[0])));
        LuceneBatchInserterIndexProviderNewImplTest.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)this.fileSystem, LuceneBatchInserterIndexProviderNewImplTest.getConfigWithProvider(), LuceneBatchInserterIndexProviderNewImplTest.getExtensions()));
    }

    private static void createEndCloseIndexProvider(BatchInserter inserter) {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(inserter);
        provider.shutdown();
        inserter.shutdown();
    }

    private static Iterable<KernelExtensionFactory<?>> getExtensions() {
        return Iterables.asIterable((Object[])new KernelExtensionFactory[]{new LuceneIndexProviderFactory()});
    }

    private static Map<String, String> getConfigWithProvider() {
        return LuceneBatchInserterIndexProviderNewImplTest.getConfig(GraphDatabaseSettings.default_schema_provider.name(), LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR.name());
    }

    private static Map<String, String> getConfig(String ... entries) {
        return MapUtil.stringMap((String[])entries);
    }

    private File getStoreDir() {
        return this.testDirectory.databaseDir();
    }
}

