/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.PooledConcurrentMergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.ThreadTestUtils;

class PooledConcurrentMergeSchedulerTest {
    private TestPooledConcurrentMergeScheduler mergeScheduler;
    private IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);

    PooledConcurrentMergeSchedulerTest() {
    }

    @BeforeEach
    void setUp() {
        this.mergeScheduler = new TestPooledConcurrentMergeScheduler();
    }

    @AfterEach
    void tearDown() {
        this.mergeScheduler.getExecutionLatch().countDown();
    }

    @Test
    void doNotAddMergeTaskWhenWriterDoesNotHaveMergesToDo() throws Exception {
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        this.mergeScheduler.merge(indexWriter, MergeTrigger.EXPLICIT, false);
        Assertions.assertEquals((long)0L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    @Test
    void addMergeTaskWhenWriterHasOneMergeToPerform() throws IOException {
        SegmentCommitInfo segmentCommitInfo = PooledConcurrentMergeSchedulerTest.getSegmentCommitInfo();
        Mockito.when((Object)this.indexWriter.getNextMerge()).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn(null);
        this.mergeScheduler.merge(this.indexWriter, MergeTrigger.EXPLICIT, false);
        Assertions.assertEquals((long)1L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    @Test
    void addTwoMergeTasksWhenWriterHastwoMergeToPerform() throws IOException {
        SegmentCommitInfo segmentCommitInfo = PooledConcurrentMergeSchedulerTest.getSegmentCommitInfo();
        Mockito.when((Object)this.indexWriter.getNextMerge()).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn(null);
        this.mergeScheduler.merge(this.indexWriter, MergeTrigger.EXPLICIT, false);
        Assertions.assertEquals((long)2L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    @Test
    void writerCloseWaitForMergesInMergeQueue() {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(10L), () -> {
            this.indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
            SegmentCommitInfo segmentCommitInfo = PooledConcurrentMergeSchedulerTest.getSegmentCommitInfo();
            Mockito.when((Object)this.indexWriter.getNextMerge()).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn(null);
            this.mergeScheduler.merge(this.indexWriter, MergeTrigger.EXPLICIT, false);
            Assertions.assertEquals((long)1L, (long)this.mergeScheduler.getWriterTaskCount());
            Thread closeSchedulerThread = ThreadTestUtils.fork(() -> this.mergeScheduler.close());
            ThreadTestUtils.awaitThreadState((Thread)closeSchedulerThread, (long)TimeUnit.SECONDS.toMillis(5L), (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
            this.mergeScheduler.getExecutionLatch().countDown();
            closeSchedulerThread.join();
            Assertions.assertEquals((long)0L, (long)this.mergeScheduler.getWriterTaskCount());
        });
    }

    private static SegmentCommitInfo getSegmentCommitInfo() {
        SegmentInfo segmentInfo = new SegmentInfo((Directory)Mockito.mock(Directory.class), Version.LATEST, "test", Integer.MAX_VALUE, true, (Codec)Mockito.mock(Codec.class), MapUtil.stringMap((String[])new String[0]), RandomUtils.nextBytes((int)16), MapUtil.stringMap((String[])new String[0]));
        return new SegmentCommitInfo(segmentInfo, 1, 1L, 1L, 1L);
    }

    private static class TestOneMerge
    extends MergePolicy.OneMerge {
        TestOneMerge(SegmentCommitInfo segmentCommitInfo) {
            super(Collections.singletonList(segmentCommitInfo));
        }
    }

    private static class TestPooledConcurrentMergeScheduler
    extends PooledConcurrentMergeScheduler {
        private CountDownLatch executionLatch = new CountDownLatch(1);

        private TestPooledConcurrentMergeScheduler() {
        }

        protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) {
            return new BlockingMerge(writer, merge, this.executionLatch);
        }

        CountDownLatch getExecutionLatch() {
            return this.executionLatch;
        }

        class BlockingMerge
        extends ConcurrentMergeScheduler.MergeThread {
            private CountDownLatch executionLatch;

            BlockingMerge(IndexWriter writer, MergePolicy.OneMerge merge, CountDownLatch executionLatch) {
                super((ConcurrentMergeScheduler)TestPooledConcurrentMergeScheduler.this, writer, merge);
                this.executionLatch = executionLatch;
            }

            public void run() {
                try {
                    this.executionLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for a latch", e);
                }
            }
        }
    }
}

