/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.IndexProviderFactoryUtil;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSlotSelector10;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;

public class NativeLuceneFusionIndexProviderFactory10
extends NativeLuceneFusionIndexProviderFactory<Dependencies> {
    private static final GraphDatabaseSettings.SchemaIndex SCHEMA_INDEX = GraphDatabaseSettings.SchemaIndex.NATIVE10;
    private static final String KEY = SCHEMA_INDEX.providerName();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, SCHEMA_INDEX.providerVersion());

    public NativeLuceneFusionIndexProviderFactory10() {
        super(KEY);
    }

    protected String descriptorString() {
        return DESCRIPTOR.toString();
    }

    protected IndexProvider internalCreate(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        return NativeLuceneFusionIndexProviderFactory10.create(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static FusionIndexProvider create(PageCache pageCache, File databaseDirectory, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        IndexDirectoryStructure.Factory childDirectoryStructure = NativeLuceneFusionIndexProviderFactory10.subProviderDirectoryStructure(databaseDirectory);
        boolean readOnly = IndexProviderFactoryUtil.isReadOnly(config, operationalMode);
        boolean archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
        NumberIndexProvider number = IndexProviderFactoryUtil.numberProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        SpatialIndexProvider spatial = IndexProviderFactoryUtil.spatialProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly, config);
        TemporalIndexProvider temporal = IndexProviderFactoryUtil.temporalProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        LuceneIndexProvider lucene = IndexProviderFactoryUtil.luceneProvider(fs, childDirectoryStructure, monitor, config, operationalMode);
        int priority = SCHEMA_INDEX.priority(config);
        return new FusionIndexProvider(IndexProvider.EMPTY, (IndexProvider)number, (IndexProvider)spatial, (IndexProvider)temporal, (IndexProvider)lucene, (SlotSelector)new FusionSlotSelector10(), DESCRIPTOR, priority, IndexDirectoryStructure.directoriesByProvider((File)databaseDirectory), fs, archiveFailedIndex);
    }

    private static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File databaseDirectory) {
        return NativeLuceneFusionIndexProviderFactory.subProviderDirectoryStructure(databaseDirectory, DESCRIPTOR);
    }

    public static interface Dependencies
    extends AbstractIndexProviderFactory.Dependencies {
    }
}

