/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.util.Collection;
import org.apache.lucene.document.Document;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.explicit.AbstractExplicitIndexHits;
import org.neo4j.index.impl.lucene.explicit.EntityId;
import org.neo4j.index.impl.lucene.explicit.IndexReference;

public class DocToIdIterator
extends AbstractExplicitIndexHits {
    private final Collection<EntityId> removedInTransactionState;
    private final EntityId.LongCostume idCostume = new EntityId.LongCostume();
    private IndexReference searcherOrNull;
    private final IndexHits<Document> source;
    private final LongSet idsModifiedInTransactionState;

    public DocToIdIterator(IndexHits<Document> source, Collection<EntityId> exclude, IndexReference searcherOrNull, LongSet idsModifiedInTransactionState) {
        this.source = source;
        this.removedInTransactionState = exclude;
        this.searcherOrNull = searcherOrNull;
        this.idsModifiedInTransactionState = idsModifiedInTransactionState;
        if (source.size() == 0) {
            this.close();
        }
    }

    protected boolean fetchNext() {
        while (this.source.hasNext()) {
            boolean idWillBeReturnedByTransactionStateInstead;
            Document doc = (Document)this.source.next();
            long id = DocToIdIterator.idFromDoc(doc);
            boolean documentIsFromStore = doc.getField("__tx_state__") == null;
            boolean bl = idWillBeReturnedByTransactionStateInstead = documentIsFromStore && this.idsModifiedInTransactionState.contains(id);
            if (this.removedInTransactionState.contains(this.idCostume.setId(id)) || idWillBeReturnedByTransactionStateInstead) continue;
            return this.next(id);
        }
        return this.endReached();
    }

    static long idFromDoc(Document doc) {
        return Long.parseLong(doc.get("_id_"));
    }

    protected boolean endReached() {
        this.close();
        return false;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.searcherOrNull.close();
            this.searcherOrNull = null;
        }
    }

    public int size() {
        return Math.max(0, this.source.size() - this.removedInTransactionState.size());
    }

    private boolean isClosed() {
        return this.searcherOrNull == null;
    }

    public float currentScore() {
        return this.source.currentScore();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

